---
id: 6732c6ab21031b60d2b0c999
title: What Are Some Common Practices for Naming Variables and Functions?
challengeType: 19
dashedName: what-are-some-common-practices-for-naming-variables-and-functions
---

# --description--

Naming variables and functions is an important aspect of writing clean, readable and maintainable code. Good naming practices makes your code self-documenting reducing the need for extensive comments and making it easier for other developers including your future self to understand your code.

Let's start with general naming conventions in JavaScript. In previous lessons you learned about using camel case for variable names. For boolean variables, it's a common practice to use prefixes such as `is`, `has`, or `can`. This immediately tells the reader that the variable is a boolean:

```js
let isLoading = true;
let hasPermission = false;
let canEdit = true;
```

For functions the name should clearly indicate what the function does. It's often helpful to start with a verb:

```js
function getUserData(){
  /* ... */
}

function calculateTotal(){
  /* ... */
}

function validateInput(){
  /* ... */
}
```

For functions that return a boolean often called predicates, you can use the same `is`, `has`, or `can` prefixes:

```js
function isValidEmail(email) {
  /* ... */
}

function hasRequiredFields(form) {
  /* ... */
}
```

When you have functions that retrieve data it's common to start with the word `get`:

```js
function getProductDetails(productId) {
  /* ... */
}

function getUserProfile(userId) {
  /* ... */
}
```

When you have functions that set data it's common to start with the word `set`:

```js
function setUserPreferences(preferences) {
  /* ... */
}

function setPageTitle(title) {
  /* ... */
}
```

For event handler functions, you might prefix with `handle` or suffix with `handler`:

```js
function handleClick(){
  /* ... */
}

function onSubmit(){
  /* ... */
}

function keyPressHandler(){
  /* ... */
}
```

An event handler is an action that happens after an event has happened like a button click. You will learn about that in future lessons.

When naming iterator variables and loops, it's common to use single letters like `i`, `j`, or `k`, but for nested loops or more complex iterations more descriptive names can be helpful:

```js
for (let i = 0; i < array.length; i++) {
  /* ... */
}

for (let studentIndex = 0; studentIndex < students.length; studentIndex++) {
  /* ... */
}
```

For array names consider using plural nouns to indicate that the variable contains multiple items:

```js
const colors = ['red', 'green', 'blue'];
const userNames = ['Alice', 'Bob', 'Charlie'];
```

Remember the goal is to make your code as self explanatory as possible. A good rule of thumb is that if you need to add a comment to explain what a variable or function does, you might want to consider renaming it to something more descriptive.

Lastly, be consistent with your codebase or team. If your team has established naming conventions, stick to them. Consistency makes the code more readable and maintainable for everyone involved.

# --questions--

## --text--

Which of the following is a good name for a boolean variable that checks if a user is logged in?

## --answers--

`user_logged`

### --feedback--

Think about the conventions we discussed for boolean variables.

---

`checkLogin`

### --feedback--

Think about the conventions we discussed for boolean variables.

---

`isLoggedIn`

---

`login`

### --feedback--

Think about the conventions we discussed for boolean variables.

## --video-solution--

3

## --text--

What's a good naming convention for a function that retrieves product information?

## --answers--

`productInformation`

### --feedback--

Remember the prefix we typically use for getter functions.

---

`getProductInfo`

---

`retrieveProduct`

### --feedback--

Remember the prefix we typically use for getter functions.

---

`prod_info`

### --feedback--

Remember the prefix we typically use for getter functions.

## --video-solution--

2

## --text--

Which of the following should you do if you’re working in an established codebase and / or with a team?

## --answers--

Use your text editor's find-and-replace feature to update any function or variable names you come across that could be improved, even it's not related to the task you're working on.

### --feedback--

Remember that this lesson covers some naming conventions, and each codebase could have its own established conventions.

---

Stick to the naming conventions for variables and functions that have already been established.

---

Come up with your own naming conventions for any new code you write.

### --feedback--

Remember that this lesson covers some naming conventions, and each codebase could have its own established conventions.

---

Strictly use the naming conventions covered in this lesson.

### --feedback--

Remember that this lesson covers some naming conventions, and each codebase could have its own established conventions.

## --video-solution--

2
