---
id: 6732c6ba2ea42b610b9f9ce1
title: How Do You Get the Length for an Array, and How Can You Create an Empty Array of Fixed Length?
challengeType: 19
dashedName: how-do-you-get-the-length-for-an-array-and-how-can-you-create-an-empty-array-of-fixed-length
---

# --description--

In prior lessons you were first introduced to the `length` property, this property returns the number of elements in an array. So here is a quick reminder on how it works:

```js
const fruits = ['apple', 'banana', 'orange'];
console.log(fruits.length); // 3
```

:::

It's possible to have arrays with empty slots. Empty slots are defined as slots with nothing in them. This is different than an array with the value of `undefined`. These types of arrays are known as sparse arrays. Here is an example:

```js
const sparseArray = [1, , , 4];
console.log(sparseArray.length); // 4
```

In this case even though we only have two defined elements, `1` and `4`, the length is `4` because the highest index (`3`) plus `1` gives us a length of `4`. 

Now let's discuss how to create an empty array of fixed length. There are few ways to do this in JavaScript but one common method is to use the `Array()` constructor with a numeric argument. The `Array()` constructor can be used with the `new` keyword to create a new array. Here is an example:

```js
const emptyArray = new Array(5);
console.log(emptyArray.length); // 5
console.log(emptyArray); // [ , , , , ]
```

In this example, we create a new array using `Array(5)`. This creates a sparse array with a length of `5` where all the slots are empty. 

Another way to create an empty array of fixed length is to use the `Array.from()` method with a length argument. Unlike `new Array(n)`, this method creates an array of the specified length where all elements exist and have a value of `undefined`: 

```js
const fixedLengthArray = Array.from({ length: 5 });
console.log(fixedLengthArray.length); // 5
console.log(fixedLengthArray); // [undefined, undefined, undefined, undefined, undefined]
```

If you want to create an array of specific length and fill it with a default value, you can use the `Array.fill()` method: 

```js
const filledArray = new Array(3).fill(0);
console.log(filledArray); // [0, 0, 0]
```

This creates an array of length three and fills all elements with the value `0`. Note: when filling with objects, all slots reference the same object; if you need independent copies, use a callback or `Array.from()` instead.

Understanding how to get the length of an array and create arrays of fixed length is important for many programming tasks especially when you need to initialize arrays for specific algorithms or data structures.

# --questions--

## --text--

What will be the output of the following code?

```js
let arr = [1, 2, 3, , 5];
console.log(arr.length);
```

## --answers--

`4`

### --feedback--

Remember that the `length` property returns the highest numeric index plus one, even if there are empty slots.

---

`5`

---

`3`

### --feedback--

Remember that the `length` property returns the highest numeric index plus one, even if there are empty slots.

---

This will throw an error.

### --feedback--

Remember that the `length` property returns the highest numeric index plus one, even if there are empty slots.

## --video-solution--

2

## --text--

Which of the following is a way to create a sparse array?

## --answers--

`new Array(5)`

---

`Array.from({ length: 5 })`

### --feedback--

Review the middle of the lesson for the answer.

---

`new Array(5).fill(undefined)`

### --feedback--

Review the middle of the lesson for the answer.

---

`[1, 2, 3, 4, 5]`

### --feedback--

Review the middle of the lesson for the answer.

## --video-solution--

1

## --text--

What will be the output of the following code?

```js
let arr = new Array(3).fill(1);
console.log(arr);
```

## --answers--

`[1, 1, 1]`

---

`[3]`

### --feedback--

The `fill()` method fills all the elements of an array with a static value.

---

`[undefined, undefined, undefined]`

### --feedback--

The `fill()` method fills all the elements of an array with a static value.

---

`[<3 empty items>]`

### --feedback--

The `fill()` method fills all the elements of an array with a static value.

## --video-solution--

1
