---
id: 67329f508a6ec45b046700b3
title: What Are the Key Characteristics of JavaScript Arrays?
challengeType: 19
dashedName: what-are-the-key-characteristics-of-javascript-arrays
---

# --interactive--

An array in JavaScript is an ordered collection of values, each identified by a numeric index. The values in a JavaScript array can be of different data types, including numbers, strings, booleans, objects, and even other arrays.

To create an array in JavaScript, you can use square brackets, `[]`, and separate the values with commas. Here's an example:

```js
let fruits = ["apple", "banana", "orange"];
```

In this example, we declare a variable `fruits` and assign it an array containing three string values: `apple`, `banana`, and `orange`.

One of the key characteristics of arrays is that they are zero-indexed, meaning that the first element in an array has an index of `0`, the second element has an index of `1`, and so on. You can access individual elements in an array using their index. For example:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange"];
console.log(fruits[0]); // "apple"
console.log(fruits[2]); // "orange"
```

:::

In this example, we use the index `0` to access the first element (`apple`) and the index `2` to access the third element (`orange`).

Arrays in JavaScript have a special `length` property that returns the number of elements in the array. You can access this property using the `length` keyword. For example:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange"];
console.log(fruits.length); // 3
```

:::

Another key characteristic of arrays in JavaScript is that they are dynamic, meaning that their size can change after they are created. You can add or remove elements from an array using various array methods, such as `push()`, `pop()`, `shift()`, `unshift()`, `splice()`, and more. These methods will be taught in upcoming lessons.

JavaScript arrays are versatile and useful when it comes to data storage inside your programs. Throughout this module, you'll get to see firsthand how working with arrays will help you efficiently manage and manipulate collections of data.

# --questions--

## --text--

Which of the following is NOT true about JavaScript arrays?

## --answers--

They are zero-indexed.

### --feedback--

Recall how each value in an array is numerically indexed, and how that affects the way values are stored.

---

They are an unordered collection of values.

---

They can contain another array as a value.

### --feedback--

Recall how each value in an array is numerically indexed, and how that affects the way values are stored.

---

They are dynamic, and their size can change after they're created.

### --feedback--

Recall how each value in an array is numerically indexed, and how that affects the way values are stored.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let numbers = [1, 2, 3, 4, 5];
console.log(numbers[2]);
```

## --answers--

`2`

### --feedback--

Remember that arrays in JavaScript are zero-indexed.

---

`3`

---

`4`

### --feedback--

Remember that arrays in JavaScript are zero-indexed.

---

`5`

### --feedback--

Remember that arrays in JavaScript are zero-indexed.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let colors = ["red", "green", "blue"];
console.log(colors.length);
```

## --answers--

`2`

### --feedback--

The length property of an array returns the number of elements it contains.

---

`3`

---

`4`

### --feedback--

The length property of an array returns the number of elements it contains.

---

`undefined`

### --feedback--

The length property of an array returns the number of elements it contains.

## --video-solution--

2
