---
id: 6732aec982904608b637716b
title: How Do You Add and Remove Elements from the Beginning and End of an Array?
challengeType: 19
dashedName: how-do-you-add-and-remove-elements-from-the-beginning-and-end-of-an-array
---

# --interactive--

Arrays in JavaScript are dynamic, which means you can easily add or remove elements from them. There are four main methods for adding and removing elements from the beginning and end of an array: `push()`, `pop()`, `shift()`, and `unshift()`. Let's explore each of these methods in detail.

The `push()` method is used to add one or more elements to the end of an array. The return value for the `push()` method is the new length of the array. Here's an example of adding a new fruit to the existing `fruits` array:

:::interactive_editor

```js
const fruits = ["apple", "banana"];
const newLength = fruits.push("orange");
console.log(newLength); // 3
console.log(fruits); // ["apple", "banana", "orange"]
```

:::

In this example, we start with an array called `fruits` which contains two elements. We then use the `push()` method to add the string `orange` to the end of the array.

You might have noticed that we are using `const` when declaring the `fruits` array. But why is it possible to add more elements to this `fruits` array when `fruits` is a constant? This is possible because declaring an array with the `const` keyword creates a reference to the array. While the array itself is mutable and can be modified, you cannot reassign a new value to the `fruits` constant, like this:

```js
const fruits = ["apple", "banana"];
fruits = ["This", "will", "not", "work"];
console.log(fruits); // Uncaught TypeError: Assignment to constant variable. 
```

The next method we will look at is the `pop()` method. The `pop()` method removes the last element from an array and returns that element. It also modifies the original array. Here's how it works:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange"];
let lastFruit = fruits.pop();
console.log(fruits); // ["apple", "banana"]
console.log(lastFruit); // "orange"
```

:::

In this example, we start with an array of three fruits. The `pop()` method removes the last element (`orange`) from the array and returns it. The original `fruits` array is modified and contains only two elements.

The `unshift()` method adds one or more elements to the beginning of an array and returns its new length. It works similarly to `push()`, but modifies the start of the array instead of the end. Here's an example:

:::interactive_editor

```js
let numbers = [2, 3];
let newLength = numbers.unshift(1);
console.log(numbers); // [1, 2, 3]
console.log(newLength); // 3
```

:::

In this example, we use `unshift()` to add the number `1` to the beginning of the `numbers` array. The method returns the new length of the array, which is `3`.

Finally, the `shift()` method removes the first element from an array and returns that element. It's similar to `pop()`, but it works at the beginning of the array instead of the end. Here's how it works:

:::interactive_editor

```js
let colors = ["red", "green", "blue"];
let firstColor = colors.shift();
console.log(colors); // ["green", "blue"]
console.log(firstColor); // "red"
```

:::

In this example, we start with an array of three colors. The `shift()` method removes the first element (`red`) from the array and returns it. The original `colors` array is modified to contain only two elements.

Note that while `push()` and `unshift()` can add multiple elements at once, `pop()` and `shift()` remove only one element at a time.

# --questions--

## --text--

What will be the output of the following code?

```js
let arr = [1, 2, 3];
arr.push(4);
arr.unshift(0);
console.log(arr);
```

## --answers--

`[1, 2, 3, 4, 0]`

### --feedback--

Consider the order of operations and what each method does to the array.

---

`[0, 1, 2, 3, 4]`

---

`[0, 4, 1, 2, 3]`

### --feedback--

Consider the order of operations and what each method does to the array.

---

`[4, 0, 1, 2, 3]`

### --feedback--

Consider the order of operations and what each method does to the array.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let arr = ["a", "b", "c", "d"];
let first = arr.shift();
let last = arr.pop();
console.log(first, last, arr);
```

## --answers--

`"a" "d" ["b", "c"]`

---

`"d" "a" ["b", "c"]`

### --feedback--

Remember that `shift()` removes from the beginning and `pop()` removes from the end.

---

`"a" "b" ["c", "d"]`

### --feedback--

Remember that `shift()` removes from the beginning and `pop()` removes from the end.

---

`"b" "c" ["a", "d"]`

### --feedback--

Remember that `shift()` removes from the beginning and `pop()` removes from the end.

## --video-solution--

1

## --text--

What will be the result of the following code?

```js
let arr = ["a", "b", "c"];
arr.unshift("x", "y");
arr.pop();
console.log(arr);
```

## --answers--

`["x", "y", "a", "b"]`

---

`["x", "y", "a", "b", "c"]`

### --feedback--

Pay attention to the order of operations and what each method does to the array.

---

`["a", "b", "x", "y"]`

### --feedback--

Pay attention to the order of operations and what each method does to the array.

---

`["y", "x", "a", "b"]`

### --feedback--

Pay attention to the order of operations and what each method does to the array.

## --video-solution--

1
