---
id: 6732aedd2d92e30923b9bc24
title: What Is Array Destructuring, and How Does It Work?
challengeType: 19
dashedName: what-is-array-destructuring-and-how-does-it-work
---

# --interactive--

Array destructuring is a feature in JavaScript that allows you to extract values from arrays and assign them to variables in a more concise and readable way. It provides a convenient syntax for unpacking array elements into distinct variables. 

This technique is particularly useful when working with arrays and functions that return multiple values. Here is an example of using array destructuring: 

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange"];

let [first, second, third] = fruits;

console.log(first);  // "apple"
console.log(second); // "banana"
console.log(third);  // "orange"
```

:::

In this example, we have an array called `fruits` with three elements. Using array destructuring, we assign the first element to the variable `first`, the second element to `second`, and the third element to `third`. This allows us to easily access individual elements of the array without using index notation. 

Here is what it would look like if you accessed each of those elements by their index instead of using array destructuring:

:::interactive_editor

```js
const fruits = ["apple", "banana", "orange"];

const first = fruits[0];
const second = fruits[1];
const third = fruits[2];

console.log(first); // "apple"
console.log(second); // "banana"
console.log(third); // "orange"
```

:::

Array destructuring also allows you to skip elements you're not interested in by using commas. For instance:

:::interactive_editor

```js
let colors = ["red", "green", "blue", "yellow"];
let [firstColor, , thirdColor] = colors;

console.log(firstColor); // "red"
console.log(thirdColor); // "blue"
```

:::

In this example, we skip the second element of the `colors` array by using an extra comma. This assigns `red` to `firstColor` and `blue` to `thirdColor`, effectively ignoring `green`.

Another powerful feature of array destructuring is the ability to use default values. If the array has fewer elements than the variables you're trying to assign, you can provide default values:

:::interactive_editor

```js
let numbers = [1, 2];
let [a, b, c = 3] = numbers;

console.log(a); // 1
console.log(b); // 2
console.log(c); // 3
```

:::

Here, we assign default value `3` to `c` because the `numbers` array doesn't have a third element.

Now, let's discuss the rest syntax, denoted by three dots (`...`). It allows you to capture the remaining elements of an array that haven’t been destructured into a new array. Here's how it works:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange", "mango", "kiwi"];
let [first, second, ...rest] = fruits;

console.log(first);  // "apple"
console.log(second); // "banana"
console.log(rest);   // ["orange", "mango", "kiwi"]
```

:::

In this example, `first` and `second` capture the first two elements of the `fruits` array, and `rest` captures all remaining elements as a new array. The rest syntax must be the last element in the destructuring pattern.

Array destructuring is a powerful feature that can make your code more concise and easier to read. It's especially useful when working with arrays, and when you need to extract specific elements from an array.

# --questions--

## --text--

What will be the output of the following code?

```js
let numbers = [1, 2, 3, 4, 5];
let [a, , b, ...rest] = numbers;
console.log(a, b, rest);
```

## --answers--

`1 2 [3, 4, 5]`

### --feedback--

Pay attention to the comma placement in the destructuring assignment and remember what the rest syntax does.

---

`1 3 [4, 5]`

---

`1 2 [4, 5]`

### --feedback--

Pay attention to the comma placement in the destructuring assignment and remember what the rest syntax does.

---

`1 3 [2, 4, 5]`

### --feedback--

Pay attention to the comma placement in the destructuring assignment and remember what the rest syntax does.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let colors = ["red", "green", "blue"];
let [primary, secondary, tertiary, quaternary = "yellow"] = colors;
console.log(quaternary);
```

## --answers--

`undefined`

### --feedback--

Consider what happens when you try to destructure more variables than there are elements in the array, and remember the concept of default values.

---

`null`

### --feedback--

Consider what happens when you try to destructure more variables than there are elements in the array, and remember the concept of default values.

---

`"yellow"`

---

This will throw an error.

### --feedback--

Consider what happens when you try to destructure more variables than there are elements in the array, and remember the concept of default values.

## --video-solution--

3

## --text--

What will be the output of the following code?

```js
let fruits = ["apple", "banana", "orange", "grape"];
let [first, ...rest, last] = fruits;
console.log(first, rest, last);
```

## --answers--

`"apple" ["banana", "orange"] "grape"`

### --feedback--

Consider the placement of the rest syntax in the destructuring assignment and think about whether this is a valid use of the rest syntax.

---

`"apple" ["banana", "orange", "grape"] undefined`

### --feedback--

Consider the placement of the rest syntax in the destructuring assignment and think about whether this is a valid use of the rest syntax.

---

This will throw a `SyntaxError`.

---

`"apple" [] "grape"`

### --feedback--

Consider the placement of the rest syntax in the destructuring assignment and think about whether this is a valid use of the rest syntax.

## --video-solution--

3
