---
id: 6732b2a6de5a1c15edf05b75
title: How Can You Use String and Array Methods to Reverse a String?
challengeType: 19
dashedName: how-can-you-use-string-and-array-methods-to-reverse-a-string
---

# --interactive--

Reversing a string is a common programming task that can be accomplished in JavaScript using a combination of string and array methods. The process involves three main steps:

- Splitting the string into an array of characters.
- Reversing the array.
- Joining the characters back into a string.

Let's explore each of these steps using the `split()`, `reverse()`, and `join()` methods.

The first step in reversing a string is to convert it into an array of individual characters. We can do this using the `split()` method. The `split()` method divides a string into an array of substrings and specifies where each split should happen based on a given separator. If no separator is provided, the method returns an array containing the original string as a single element. Examples of common separators include:

- An empty string (`""`), which splits the string into individual characters.

- A single space (`" "`), which splits the string wherever spaces occur.

- A dash (`"-"`), which splits the string at each dash.

Here's an example of using the split method to create an array of characters:

:::interactive_editor

```js
let str = "hello";
let charArray = str.split("");
console.log(charArray); // ["h", "e", "l", "l", "o"]
```

:::

In this example, we use `split("")` (with an empty string pass to it) to convert the string `hello` into an array of its individual characters. Once we have an array of characters, we can use the `reverse()` method to reverse the order of elements in the array. 

The `reverse()` method is an array method that reverses an array in place. This means it modifies the original array rather than creating a new one. Here's how we can use it:

:::interactive_editor

```js
let charArray = ["h", "e", "l", "l", "o"];
charArray.reverse();
console.log(charArray); // ["o", "l", "l", "e", "h"]
```

:::

In this example, `reverse()` changes the order of elements in `charArray`, reversing it from `["h", "e", "l", "l", "o"]` to `["o", "l", "l", "e", "h"]`.

The final step is to convert the reversed array of characters back into a string. We can accomplish this using the `join()` method. The `join()` method creates and returns a new string by concatenating all of the elements in an array, separated by a specified separator string. If you want to join the characters without any separator, you can use an empty string as the argument. Here's an example:

:::interactive_editor

```js
let reversedArray = ["o", "l", "l", "e", "h"];
let reversedString = reversedArray.join("");
console.log(reversedString); // "olleh"
```

:::

In this example, `join("")` (with an empty string pass to it as an argument) combines all the characters in the array into a single string without any separator between them.

Remember that strings in JavaScript are immutable, which means you can't directly reverse a string by modifying it. That's why we need to convert it to an array, reverse the array, and then convert it back to a string. This combination of string and array methods provides a powerful and flexible way to manipulate strings in JavaScript.

# --questions--

## --text--

What will be the output of the following code?

```js
let str = "coding";
let reversed = str.split("").reverse().join("");
console.log(reversed);
```

## --answers--

`coding`

### --feedback--

Remember the order of operations: `split`, `reverse`, then `join`.

---

`gnidoc`

---

`["g", "n", "i", "d", "o", "c"]`

### --feedback--

Remember the order of operations: `split`, `reverse`, then `join`.

---

`undefined`

### --feedback--

Remember the order of operations: `split`, `reverse`, then `join`.

## --video-solution--

2

## --text--

What will be the result of `"hello".split("")`?

## --answers--

`"hello"`

### --feedback--

The `split("")` method splits a string into an array of individual characters.

---

`["hello"]`

### --feedback--

The `split("")` method splits a string into an array of individual characters.

---

`["h", "e", "l", "l", "o"]`

---

`"h,e,l,l,o"`

### --feedback--

The `split("")` method splits a string into an array of individual characters.

## --video-solution--

3

## --text--

What will be the output of the following code?

```js
let word = "hello";
let chars = word.split("");
chars.reverse();
console.log(chars.join("-"));
```

## --answers--

`hello`

### --feedback--

Pay attention to the separator used in the `join()` method.

---

`o-l-l-e-h`

---

`olleh`

### --feedback--

Pay attention to the separator used in the `join()` method.

---

`["o", "l", "l", "e", "h"]`

### --feedback--

Pay attention to the separator used in the `join()` method.

## --video-solution--

2
