---
id: 672c37498952920879c43de9
title: How to Use the Attribute Selector to Target Elements with the lang and data-lang Attributes?
challengeType: 19
dashedName: how-to-use-the-attribute-selector-to-target-elements-with-the-lang-and-data-lang-attributes
---

# --interactive--

When building multilingual websites or handling custom data attributes, you often need to style elements based on the language they contain or specific data values.

The `lang` and `data-lang` attributes are commonly used for these purposes, and the attribute selector in CSS allows you to apply styles based on these attributes effectively.

The `lang` attribute is used in HTML to specify the language of the content within an element. You might want to style elements differently based on the language they are written in, especially on a multilingual website.

Here's an example of how you can use the attribute selector to target elements with a specific `lang` attribute:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p lang="en">This is an English paragraph.</p>
<p lang="fr">Ceci est un paragraphe en français.</p>
```

```css
p[lang="en"] {
  font-style: italic;
}
```

:::

This CSS rule applies italic styling to any paragraph element where the `lang` attribute is set to English (`en`). This could be useful for emphasizing English text in a document that includes multiple languages.

Similarly, you can use the attribute selector to target elements with a `data-lang` attribute. 

Custom data attributes like `data-lang` are commonly used to store additional information in elements, such as specifying the language used within a specific section of text. 

Here's how you can use CSS to target and style elements based on the `data-lang` attribute:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p data-lang="fr">Ceci est un paragraphe en français.</p>
<p data-lang="en">This is a paragraph in English.</p>
```

```css
p[data-lang="fr"] {
  color: blue;
}
```

:::

In this case, any `p` element with a `data-lang` attribute set to French (`fr`) will have its text color changed to blue. This allows you to quickly identify and style sections of content based on the language information stored in the `data-lang` attribute.

Attribute selectors like these provide a powerful way to apply conditional styling based on the metadata embedded within your HTML, making your web pages more dynamic and context-aware.

# --questions--

## --text--

Which CSS selector would you use to target all paragraphs where the `lang` attribute is set to English?

## --answers--

`p[lang="en"]`

---

`p[lang]`

### --feedback--

Consider the selector that targets elements with a specific `lang` attribute value.

---

`p[lang="es"]`

### --feedback--

Consider the selector that targets elements with a specific `lang` attribute value.

---

`p[lang*="en"]`

### --feedback--

Consider the selector that targets elements with a specific `lang` attribute value.

## --video-solution--

1

## --text--

How would you target all `div` elements that have a `data-lang` attribute set to `fr`?

## --answers--

`div[data-lang]`

### --feedback--

Think about the selector that matches the exact value of the `data-lang` attribute.

---

`div[data-lang="fr"]`

---

`div[lang="fr"]`

### --feedback--

Think about the selector that matches the exact value of the `data-lang` attribute.

---

`div[data-lang*="fr"]`

### --feedback--

Think about the selector that matches the exact value of the `data-lang` attribute.

## --video-solution--

2

## --text--

Which attribute would you use in HTML to specify the language of the content inside an element?

## --answers--

`data-lang`

### --feedback--

This attribute is commonly used to define the language for accessibility and SEO purposes.

---

`class`

### --feedback--

This attribute is commonly used to define the language for accessibility and SEO purposes.

---

`lang`

---

`id`

### --feedback--

This attribute is commonly used to define the language for accessibility and SEO purposes.

## --video-solution--

3
