---
id: 6733ab12b60bd7f6b2b0b0c0
title: How Does the Audio Constructor Work, and What Are Some Common Methods?
challengeType: 19
dashedName: how-does-the-audio-constructor-work-and-what-are-some-common-methods
---

# --description--

Let's learn about the `Audio` constructor and its common methods.

The `Audio` constructor, like other constructors, is a special function called with the `new` keyword. It returns an `HTMLAudioElement`, which you can then use to play audio for the user, or append to the DOM for the user to control themselves.

When you call the constructor, you can optionally pass a URL as the (only) argument. This URL should point to the source of the audio file you want to play. Or, if you need to change the source dynamically, you can assign the URL to the `src` property of the returned audio element.

The returned audio element offers various methods for controlling the audio. You'll most likely use the `play()` method, which begins audio playback. There is also the `pause()` method, which pauses the audio playback but preserves the current location in the track allowing `play()` to resume playback from that point.

You might expect there to be a `stop()` method, to pause audio playback and reset the track to the beginning. But instead, you should call `pause()` and set the `currentTime` property directly.

Finally, the `canPlayType()` method can be used to determine if a browser is likely to be able to play your specific audio format. You will learn about audio and video formats in the next lesson.

# --questions--

## --text--

What does the `Audio` constructor return when called with the `new` keyword?

## --answers--

An `AudioContext` object.

### --feedback--

The constructor returns a specific type of HTML element.

---

A `MediaElement`.

### --feedback--

The constructor returns a specific type of HTML element.

---

An `HTMLAudioElement`.

---

A Promise that resolves to an audio file.

### --feedback--

The constructor returns a specific type of HTML element.

## --video-solution--

3

## --text--

How can you set the source of an audio file for an `Audio` object?

## --answers--

By passing a URL as an argument to the `Audio` constructor.

### --feedback--

There are two ways to set the audio source.

---

By assigning a URL to the `src` property of the `audio` element.

### --feedback--

There are two ways to set the audio source.

---

By using the `setSource()` method.

### --feedback--

There are two ways to set the audio source.

---

By either passing a URL to the constructor or setting the `src` property.

## --video-solution--

4

## --text--

Which method should you use to pause audio playback and reset the track to the beginning?

## --answers--

Call the `stop()` method.

### --feedback--

The lesson mentions the two things you need to do to pause and reset the audio back to the beginning.

---

Call the `reset()` method.

### --feedback--

The lesson mentions the two things you need to do to pause and reset the audio back to the beginning.

---

Call the `pause()` method, and then set `currentTime` property.

---

Call the `pause()` method, and then call the `reset()` method.

### --feedback--

The lesson mentions the two things you need to do to pause and reset the audio back to the beginning.

## --video-solution--

3
