---
id: 6733d8203da84a08a0f5eab4
title: What Are the Different Types of Video and Audio Formats?
challengeType: 19
dashedName: what-are-the-different-types-of-video-and-audio-formats
---

# --description--

Let's learn about the different types of audio and video formats.

You have probably heard of, or even used, a few common ones. If the terms MP3, MP4, MOV, or WebM are familiar to you, those are all different formats for video and audio. And there are quite a few more that are available.

Before we dive in to file formats, we need to talk about MIME types. A MIME type, standing for Multipurpose Internet Mail Extensions, is a standardized way to programmatically indicate a file type.

Nearly every file format has a MIME type. HTML, for example, has the type `text/html`. A JSON object has the type `application/json`. Even a Windows `.exe` installer has a MIME type: `application/vnd.microsoft.portable-executable`.

The MIME type can tell an application, such as your browser, how to handle a specific file. In the case of audio and video, the MIME type indicates it is a multimedia format that can be embedded in the web page.

An MP3 file has the MIME type `audio/mp3`. An MP4, however, can have the MIME type `audio/mp4` OR `video/mp4`, depending on whether it's a video file or audio-only. This distinction tells the browser how to handle the file.

There are plenty of other file formats, such as the waveform format WAV, the multipurpose OGG, WMV for the Windows media player, the open source MKV, and many more.

Knowing the differences between these file formats can help you ensure your users get the best experience, but sometimes you can't know what format a user's computer will support (or not support). Thankfully, `video` and `audio` elements both support the `source` element.

With the `source` element, you can specify a file type and `source` and can include multiple different types by using multiple `source` elements. When you do this, the browser will determine the best format to use for the user's current environment.

This takes away the guess work and allows you to focus on building engaging applications.

# --questions--

## --text--

What does MIME stand for in the context of file types?

## --answers--

Multimedia Internet Media Extension.

### --feedback--

MIME type was originally for mail.

---

Multiple Internet Mail Extensions.

### --feedback--

MIME type was originally for mail.

---

Multipurpose Internet Mail Extensions.

---

Media Information and Metadata Encoding.

### --feedback--

MIME type was originally for mail.

## --video-solution--

3

## --text--

What is the primary purpose of a MIME type?

## --answers--

To compress file sizes for faster internet transfer.

### --feedback--

A MIME type indicates the type of file.

---

To encrypt files for secure transmission.

### --feedback--

A MIME type indicates the type of file.

---

To standardize the way file types are indicated programmatically.

---

To convert files between different formats

### --feedback--

A MIME type indicates the type of file.

## --video-solution--

3

## --text--

What is the MIME type for an MP3 file?

## --answers--

`audio/mpeg`

### --feedback--

An MP3 file cannot contain video.

---

`audio/mp3`

---

`video/mp3`

### --feedback--

An MP3 file cannot contain video.

---

`application/mp3`

### --feedback--

An MP3 file cannot contain video.

## --video-solution--

2
