---
id: 6733d829d983c008d2db41a1
title: What Are Codecs and How Do They Work?
challengeType: 19
dashedName: what-is-codecs-and-how-does-it-work
---

# --description--

Let's learn about codecs and how they work.

If you have worked with videos or audio before, you may have heard about codecs. A codec, short for "encoder/decoder", is an algorithm or software that can convert audio and video between analogue and digital formats.

Codecs can be specified as part of the MIME type. The basic syntax to define a codec is to add a semi-colon after the media type, then `codecs=` and the codec.

For example, an OGG audio file which uses the Vorbis codec might have a MIME type of `audio/ogg; codecs=vorbis`. Or, if a file supports multiple codecs, you can specify them as comma separated, but must surround them with quotes: `video/webm; codecs="vp8, vorbis"`.

But some file types have a much more complicated syntax for codecs. For example, an MP4 might have a codec of `codecs="avc1.4d002a"`, indicating it was encoded with H.264.

But when might you actually use these? Well, you can include them in the `type` attribute for a `source` element. This allows you to specify different codecs for the same format, giving the browser more granular options when determining which format to use for that user's environment.

But you can also use them as part of the MIME type you pass to the global `MediaSource.isTypeSupported()` method. This method accepts a MIME-type, and returns `true` if the environment is likely to support it. Or rather, it returns `false` if it fails to instantiate a buffer for that file type. This approach allows you to programmatically select a source yourself, rather than relying on whatever the browser determines is "best".

# --questions--

## --text--

What does the term "codec" stand for in the context of multimedia?

## --answers--

Compress/Decompress

### --feedback--

A codec denotes how a file has been encoded.

---

Code/Decode

### --feedback--

A codec denotes how a file has been encoded.

---

Encoder/Decoder

---

Encrypt/Decrypt

### --feedback--

A codec denotes how a file has been encoded.

## --video-solution--

3

## --text--

How are codecs specified as part of the MIME type?

## --answers--

By adding a prefix before the media type.

### --feedback--

Codecs are specified in the MIME type, as an attribute after the media type.

---

By adding a suffix after the media type.

### --feedback--

Codecs are specified in the MIME type, as an attribute after the media type.

---

By adding a semi-colon after the media type, followed by `codecs=` and the codec name.

---

By replacing the media type entirely with the codec name.

### --feedback--

Codecs are specified in the MIME type, as an attribute after the media type.

## --video-solution--

3

## --text--

What is the purpose of the `MediaSource.isTypeSupported()` method?

## --answers--

To automatically convert a file to a supported format.

### --feedback--

This method tries to instantiate a buffer for the specified file type, to determine if the type is supported.

---

To check if a specific MIME type and codec are likely supported in the current environment.

---

To force the browser to use a specific codec.

### --feedback--

This method tries to instantiate a buffer for the specified file type, to determine if the type is supported.

---

To list all supported codecs in the current environment.

### --feedback--

This method tries to instantiate a buffer for the specified file type, to determine if the type is supported.

## --video-solution--

2
