---
id: 6733d8606fb893099e3d0df3
title: What Are Some Other Examples of Video and Audio APIs?
challengeType: 19
dashedName: what-are-some-other-examples-of-video-and-audio-apis
---

# --description--

You've learned about the `HTMLMediaElement` and MediaStreams APIs, but there are a few more APIs that can be quite helpful in working with video and audio.

The first is the Screen Capture API. As the name might suggest, this API allows you to record a user's screen. This API is exposed by calling the `getDisplayMedia()` method of the `mediaDevices` object and consuming the returned media stream.

Then there is the MediaStream Recording API. This API works in tandem with the MediaStreams APIs, allowing you to record a MediaStream (or even an `HTMLMediaElement` directly). It then fires `dataavailable` events with Blob payloads you can write to the local file storage.

Underlying all of this technology is the Media Source Extensions API. The Media Source Extensions API is what allows you to directly pass a user's webcam feed to a video element with the `srcObject` property, for example. 

And finally, the Web Audio API which powers everything audible on the web. This API includes important objects like an `AudioBuffer` (representing a Buffer specifically containing audio data) or the `AudioContext`. 

And that wraps up our lessons on audio and video!

# --questions--

## --text--

What is the primary function of the Screen Capture API?

## --answers--

To play video files.

### --feedback--

Think about the meaning of "screen capture".

---

To record a user's screen.

---

To edit video content.

### --feedback--

Think about the meaning of "screen capture".

---

To stream video from external sources.

### --feedback--

Think about the meaning of "screen capture".

## --video-solution--

2

## --text--

Which method is used to access the Screen Capture API?

## --answers--

`getScreenMedia()`

### --feedback--

Remember that screens are considered displays.

---

`captureScreen()`

### --feedback--

Remember that screens are considered displays.

---

`getDisplayMedia()`

---

`recordScreen()`

### --feedback--

Remember that screens are considered displays.

## --video-solution--

3

## --text--

Which API allows you to pass a user's webcam feed directly to a `video` element's `srcObject` property?

## --answers--

Screen Capture API

### --feedback--

This core API extends the behavior of media sources.

---

MediaStream Recording API

### --feedback--

This core API extends the behavior of media sources.

---

Media Source Extensions API

---

Web Audio API

### --feedback--

This core API extends the behavior of media sources.

## --video-solution--

3
