---
id: 672aa669960f6a596081fcad
title: How Do Background Image Size, Repeat, Position, and Attachment Work?
challengeType: 19
dashedName: how-to-work-with-background-image-size-repeat-position-and-attachment
---

# --interactive--

When working with background images in CSS, you have several properties at your disposal to control how these images are displayed.

The main properties we'll focus on are `background-size`, `background-repeat`, `background-position`, and `background-attachment`.

Let’s first take a look at the `background-image` property:

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
  }
</style>
```

:::

The above CSS sets a cat background image for the `body` element.

If you want to set the size for the background image, you can use the `background-size` property.

You can use `contain` to scale the image as large as possible without cropping or stretching.

Here's an example with `background-size: contain`:

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-size: contain;
    min-height: 100px;
  }
</style>
```

:::

We are setting the `min-height` to `100px` so the background image is visible and the layout maintains a baseline height, ensuring that even with minimal content, the design appears balanced and visually appealing.

If we change the `background-size` property to use the `cover` value, then the background image will scale to cover the entire `body` element while maintaining its aspect ratio.

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-size: cover;
    min-height: 100px;
  }
</style>
```

:::

In the previous examples, you probably noticed that the background image would continuously repeat.

By default, background images repeat both horizontally and vertically to fill the entire element. However, you can control this behavior.

You can use the `background-repeat` property with the value set to `no-repeat`.

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-size: contain;
    background-repeat: no-repeat;
    min-height: 100px;
  }
</style>
```

:::

With the `background-size` set to `contain` and the `background-repeat` set to `no-repeat`, the image will no longer repeat on the screen.

If you wanted to repeat the background image horizontally, you can use the `repeat-x` value for the `background-repeat` property.

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-size: contain;
    background-repeat: repeat-x;
    min-height: 100px;
  }
</style>
```

:::

If you wanted to repeat the background image vertically, you can use the `repeat-y` value for the `background-repeat` property.

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-size: contain;
    background-repeat: repeat-y;
    min-height: 100px;
  }
</style>
```

:::

To position a background image on the screen, you can use the `background-position` property.

The `background-position` property allows you to set where in the element the background image appears. You can use keywords like `top`, `bottom`, `left`, `right`, and `center`, or specific pixel or percentage values.

Here is an example using the `center` and `top` for the `background-position`:

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-size: contain;
    background-repeat: no-repeat;
    background-position: center top;
    min-height: 100px;
  }
</style>
```

:::

This CSS code positions the background image at the center of the element horizontally and at the top vertically.

Lastly, `background-attachment` determines whether the background image scrolls with the content or remains fixed when the page is scrolled.

The main values are `scroll` (default), where the background image scrolls with the content, and `fixed`, where the background image stays in the same position on the screen.

Here is an example using the `fixed` value for the `background-attachment` property:

:::interactive_editor

```html
<style>
  body {
    background-image: url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
    background-position: center top;
    background-attachment: fixed;
  }
</style>
```

:::

This CSS code sets the background image to remain fixed in place even when the page is scrolled.

If you wanted to combine a few of the properties into one line, you can do that by using the shorthand `background` property.

Here is an example:

:::interactive_editor

```html
<style>
  body {
    background: center top fixed
      url("https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg");
  }
</style>
```

:::

The above example combines the `background-image`, `background-position`, and `background-attachment` into a single line.

By mastering these properties, you'll have great control over how background images are displayed in your web designs, allowing for more visually appealing and functional layouts.

# --questions--

## --text--

Which `background-size` value would you use to ensure the entire background image is visible without any cropping, even if it doesn't cover the whole element?

## --answers--

`cover`

### --feedback--

Think about which option ensures the full image is shown without stretching or cropping.

---

`contain`

---

`auto`

### --feedback--

Think about which option ensures the full image is shown without stretching or cropping.

---

`100%`

### --feedback--

Think about which option ensures the full image is shown without stretching or cropping.

## --video-solution--

2

## --text--

If you want a background image to repeat horizontally but not vertically, which `background-repeat` value would you use?

## --answers--

`repeat`

### --feedback--

Consider which option specifically mentions horizontal repetition.

---

`no-repeat`

### --feedback--

Consider which option specifically mentions horizontal repetition.

---

`repeat-x`

---

`repeat-y`

### --feedback--

Consider which option specifically mentions horizontal repetition.

## --video-solution--

3

## --text--

Which `background-attachment` value would you use to make a background image stay in place when the user scrolls the page?

## --answers--

`scroll`

### --feedback--

Think about which term implies the image doesn't move with scrolling.

---

`fixed`

---

`local`

### --feedback--

Think about which term implies the image doesn't move with scrolling.

---

`static`

### --feedback--

Think about which term implies the image doesn't move with scrolling.

## --video-solution--

2
