---
id: 672b98db3bcdd545ab3b3c73
title: What Are the Different Ways You Can Add Borders Around Images?
challengeType: 19
dashedName: what-are-the-different-ways-you-can-add-borders-around-images
---

# --interactive--

In CSS, there are several ways to add borders around images, each offering different styling options and levels of control.

Let's explore some of the most common and versatile methods.

The most straightforward way to add a border to an image is by using the `border` property. This property is a shorthand that allows you to set the width, style, and color of the border all at once.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute cat lying on its back.">
```

```css
img {
  border: 2px solid red;
}
```

:::

This CSS rule adds a 2-pixel wide, solid red border around all `img` elements. You can adjust the width, style (such as `dashed`, `dotted`, or `double`), and color to suit your design needs.

If you need more control over individual sides of the border, you can use the specific border properties for each side:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute cat lying on its back.">
```

```css
img {
  border-top: 10px solid red;
  border-right: 10px dashed green;
  border-bottom: 10px dotted blue;
  border-left: 10px double purple;
}
```

:::

This allows you to create unique border styles for each side of the image.

Another way to create a border effect is by using the `outline` property. While similar to border, outline doesn't affect the element's dimensions or layout:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute cate lying on its back.">
```

```css
img {
  outline: 3px solid gold;
}
```

:::

This creates a gold outline around the image without changing its size or position.

If you want to create rounded corners on your border, you can use the `border-radius` property in conjunction with border:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute cate lying on its back.">
```

```css
img {
  border: 2px solid black;
  border-radius: 10px;
}
```

:::

Remember, these techniques can be combined and customized to create unique border effects. The choice of method depends on your specific design requirements and the level of complexity you need.

# --questions--

## --text--

Which CSS property allows you to create a border that doesn't affect the element's dimensions?

## --answers--

`border`

### --feedback--

Think about which property creates a line around an element without changing its size or position.

---

`outline`

---

`box-shadow`

### --feedback--

Think about which property creates a line around an element without changing its size or position.

---

`border-image`

### --feedback--

Think about which property creates a line around an element without changing its size or position.

## --video-solution--

2

## --text--

How would you create a 3-pixel wide, dashed, red border only on the left side of an image?

## --answers--

```css
img {
  border: 3px dashed red left;
}
```

### --feedback--

Consider which property specifically targets one side of an element's border.

---

```css
img {
  border-left: 3px dashed red;
}
```

---

```css
img {
  left-border: 3px dashed red;
}
```

### --feedback--

Consider which property specifically targets one side of an element's border.

---

```css
img {
  border: left 3px dashed red;
}
```

### --feedback--

Consider which property specifically targets one side of an element's border.

## --video-solution--

2

## --text--

Which CSS property would you use to round the corners of a border?

## --answers--

`border-style`

### --feedback--

Think of a word related to a circle or curve.

---

`border-radius`

---

`border-spacing`

### --feedback--

Think of a word related to a circle or curve.

---

`border-bottom`

### --feedback--

Think of a word related to a circle or curve.

## --video-solution--

2
