---
id: 6733ff4a9319c8486750886c
title: What Is localStorage, and What Are Some Common Methods?
challengeType: 19
dashedName: what-is-localstorage-and-what-are-some-common-methods
---

# --description--

The Web Storage API provides a mechanism for browsers to store key-value pairs right within the browser, allowing developers to store information that can be used across different page reloads and sessions. 

The two main components in the Web Storage API are `localStorage` and `sessionStorage`.

`localStorage` is the part of the Web Storage API that allows data to persist even after the browser window is closed or the page is refreshed. This data remains available until it is explicitly removed by the application or the user. 

`sessionStorage` is another part of the Web Storage API that stores data for the duration of the page session, meaning the data is available as long as the browser tab or window is open. However, unlike `localStorage`, the data in `sessionStorage` is cleared when the tab or window is closed. You will learn more about `sessionStorage` in the next lesson. 

Common use cases for `localStorage` include storing user settings, such as themes or language preferences, remembering form data across browser sessions, and caching small pieces of information to improve the performance of web apps.

Caching refers to storing frequently accessed data in a temporary storage location, known as a cache, so that subsequent requests for that data can be served more quickly without having to recompute or fetch it from a slower data source, such as a database or external server.

Some common `localStorage` methods include the `setItem`, `getItem`, `removeItem` and `clear` methods. 

Here is an example of using the `setItem()` method which stores a key-value pair in `localStorage`.

```js
localStorage.setItem('username', 'JaneDoe');
```

Then if we want retrieve that value of a given key from `localStorage`, we can use the `getItem()` method.

```js
let username = localStorage.getItem('username');
console.log(username); // JaneDoe
```

To remove an item from `localStorage` using its key, you can use the `removeItem()` method.

```js
localStorage.removeItem('username');
```

To clear all data in `localStorage`, you can use the `clear()` method.

```js
localStorage.clear();
```

Now, let’s take a look at an example where we use `localStorage` to store the preferred theme of a user.

```js
// Store the user's theme preference
localStorage.setItem('theme', 'dark');

// Retrieve the stored theme preference
const userTheme = localStorage.getItem('theme');
console.log(userTheme); // 'dark'

// Remove the theme preference
localStorage.removeItem('theme');

// Clear all localStorage data
localStorage.clear();
```

In this example:

- We first store a theme choice (`dark`) for the user.

- We then retrieve that theme and output it to the console.

- Finally, we demonstrate how to remove a specific item or clear all stored data.

`localStorage` is very useful for storing small pieces of data that need to persist between sessions, but it's important to note that `localStorage` should not be used to store sensitive information, such as passwords, because it can pose security risks.

# --questions--

## --text--

What is the purpose of the Web Storage API?

## --answers--

To send small pieces of data to the server with every HTTP request.

### --feedback--

The Web Storage API helps you store data directly in the user's browser.

---

To store key-value pairs in the browser.

---

To store sensitive data in encrypted form.

### --feedback--

The Web Storage API helps you store data directly in the user's browser.

---

To run JavaScript code on the server.

### --feedback--

The Web Storage API helps you store data directly in the user's browser.

## --video-solution--

2

## --text--

Which method is used to save data in local storage?

## --answers--

`localStorage.getItem()`

### --feedback--

The method starts with `set` and involves setting a key-value pair.

---

`localStorage.setItem()`

---

`localStorage.save()`

### --feedback--

The method starts with `set` and involves setting a key-value pair.

---

`localStorage.store()`

### --feedback--

The method starts with `set` and involves setting a key-value pair.

## --video-solution--

2

## --text--

How does `localStorage` differ from `sessionStorage`?

## --answers--

`localStorage` data is cleared when the tab is closed, `sessionStorage` is permanent.

### --feedback--

Think about what happens to `localStorage` when you close and reopen the browser.

---

`localStorage` persists across browser sessions, while `sessionStorage` is cleared when the browser or tab is closed.

---

`localStorage` sends data to the server, `sessionStorage` stores data locally.

### --feedback--

Think about what happens to `localStorage` when you close and reopen the browser.

---

Both behave the same way and there is no difference.

### --feedback--

Think about what happens to `localStorage` when you close and reopen the browser.

## --video-solution--

2
