---
id: 6733ff9d2fb9c449af68ad99
title: What Are Some Negative Patterns Associated with Client-Side Storage?
challengeType: 19
dashedName: what-are-some-negative-patterns-associated-with-client-side-storage
---

# --interactive--

Client-side storage allows websites to store data on a user's device. However, like many technologies, it can be misused. 

Let’s explore some negative patterns associated with client-side storage, focusing on cookies and their misuse for tracking and fingerprinting.

Let's start with cookies. 

In an earlier lesson, you learned that cookies are data stored on a user's device when they visit a web app. A common misuse of cookies is excessive tracking.

Websites use cookies to track a user's interactions with a web app, creating a history of their digital activities. This is done for targeted advertising but can raise significant privacy concerns.

For example, a shopping website might use a tracking cookie like this:

```js
document.cookie = "userID=123; path=/; expires=Thu, 18 Dec 2024 6:00:00 UTC";
```

This code sets a cookie named `userID` with a value of `123`. The cookie will be sent with every request to the website, allowing it to track the user's actions. While this might seem harmless, imagine hundreds of websites sharing this information – it could create a very detailed picture of your online life and choices.

Another concerning practice is browser fingerprinting. 

This technique uses client-side information to create a unique "fingerprint" of a user's browser. Websites have the ability to gather information about your browser version, installed plugins, screen resolution, and other data to uniquely identify you. 

Here's a simple example of how a website can create a fingerprint of you:

:::interactive_editor

```js
let fingerprintExample = navigator.userAgent + screen.width + screen.height;
console.log(fingerprintExample);
```

:::

This code combines your browser's user agent with your screen dimensions. While this is a basic example, real fingerprinting methods are much more complex and can be highly accurate in identifying users.

`localStorage` can also be misused as some websites use it to store sensitive information insecurely. For instance:

```js
localStorage.setItem('userPassword', 'someonesPasswordHere');
```

This code stores a user's password in `localStorage`. This is a serious security risk as the data in `localStorage` is not encrypted and can be accessed easily.

In conclusion, while client-side storage offers many benefits, it's crucial to use it responsibly. As you continue your web development journey, always consider the privacy and security of your users' data on the client side.

# --questions--

## --text--

What is a potential negative use of cookies in web development?

## --answers--

Remembering user login information.

### --feedback--

Think about which option might raise privacy concerns.

---

Tracking user behavior across multiple websites.

---

Storing user preferences.

### --feedback--

Think about which option might raise privacy concerns.

---

Improving website load times.

### --feedback--

Think about which option might raise privacy concerns.

## --video-solution--

2

## --text--

What is browser fingerprinting?

## --answers--

A technique to improve browser security.

### --feedback--

Consider which option relates to identifying individual users.

---

A method to create unique browser themes.

### --feedback--

Consider which option relates to identifying individual users.

---

A way to identify users based on browser and system characteristics.

---

A process to optimize website performance for different browsers.

### --feedback--

Consider which option relates to identifying individual users.

## --video-solution--

3

## --text--

Why is storing sensitive information like passwords in `localStorage` a security risk?

## --answers--

`localStorage` has limited capacity.

### --feedback--

Think about the security features (or lack thereof) in `localStorage`.

---

Data in `localStorage` is not encrypted.

---

`localStorage` is slower than cookies.

### --feedback--

Think about the security features (or lack thereof) in `localStorage`.

---

`localStorage` doesn't work in all browsers.

### --feedback--

Think about the security features (or lack thereof) in `localStorage`.

## --video-solution--

2
