---
id: 672d45651d83b450801efb3a
title: How to Create a Project and Run Your Code Locally in VS Code
challengeType: 19
dashedName: how-to-create-a-project-and-run-your-code-locally-in-vs-code
---

# --description--

To get started, you should know that VS Code considers projects to be "workspaces". The workspace is whichever directory you opened in VS Code.

To begin, you will need to use a command line interface to create a new directory for your new project. A directory is another name for the folder.

Command-line interfaces, or CLI for short, allow you to interact with your operating system through text-based commands. You will learn more about these tools in future lessons.

If you are on Windows, you can use the Command Prompt or PowerShell. If you are on a Mac, you can open up your Terminal app.

Once the command line is open, navigate to the home directory by typing in the `cd ~` command and hitting `enter` on your keyboard. Then type in the `mkdir my-project` command and hit `enter`. `mkdir`, or "make directory" is the command used to create a new directory. You should then open your new directory with VS Code. 

There are also some other graphical ways to create a new directory.

Depending on your operating system, you might have a context menu (or right-click option) to open VS Code directly from your file explorer. You could also choose to double-click on the VS Code application. If you feel comfortable with the command line you can run the command `code /path/to/folder`.

Once it's open, you should see a new blank workspace.

To create a new file, click on the `File` menu at the top-left corner and select `New File...`. Then name your file `index.html` and click on `Save`.

Now you should see your new file in the explorer tab. Try adding some HTML to your `index.html` file.

Now you might be tempted to open the HTML file in your browser directly. While that can work, it can also lead to all sorts of unexpected bugs, such as CSS not loading properly.

Instead, you should put your HTML file behind a proper web server. That can sound like an intimidating task if you are new to coding, but there's actually a way to do this right from VS Code.

You'll need to grab the _Live Server_ extension first, which is available for free in the marketplace.

Click on the extensions tab in the left hand corner and type in `Live Server` in the search bar.

Once you have this installed, you should see a `Go live` button in your status bar. Make sure you have your HTML file open, and then click it.

Your new page should open automatically in a new tab in the browser. If it doesn't then you can go directly to `http://localhost:5500/`

Congratulations! You've now set up your very own project in VS Code, and can view your changes with live server.

# --questions--

## --text--

What does Visual Studio Code consider to be a "workspace"?

## --answers--

The entire hard drive.

### --feedback--

The lesson mentions how VS Code defines a workspace in relation to directories.

---

The directory you opened VS Code from.

---

All open files in VS Code.

### --feedback--

The lesson mentions how VS Code defines a workspace in relation to directories.

---

The VS Code application folder.

### --feedback--

The lesson mentions how VS Code defines a workspace in relation to directories.

## --video-solution--

2

## --text--

Why does the lesson recommend using a web server instead of opening an HTML file directly in a browser?

## --answers--

It's faster to load and makes it easier to spot issues in your codebase.

### --feedback--

The lesson mentions a specific issue that can occur when opening HTML files directly.

---

It provides better security for large software applications.

### --feedback--

The lesson mentions a specific issue that can occur when opening HTML files directly.

---

It avoids unexpected bugs, such as CSS not loading properly.

---

It allows for real-time collaboration with other developers on a team.

### --feedback--

The lesson mentions a specific issue that can occur when opening HTML files directly.

## --video-solution--

3

## --text--

What VS Code extension is recommended for easily setting up a local web server?

## --answers--

Web Server.

### --feedback--

The lesson specifically mentions installing an extension from the marketplace to serve your HTML file.

---

Live Server.

---

Local Host.

### --feedback--

The lesson specifically mentions installing an extension from the marketplace to serve your HTML file.

---

HTML Preview.

### --feedback--

The lesson specifically mentions installing an extension from the marketplace to serve your HTML file.

## --video-solution--

2
