---
id: 672bc523324694be91d90d96
title: What Is the HSL Color Model, and How Does the HSL Function Work in CSS?
challengeType: 19
dashedName: what-is-the-hsl-color-model
---

# --interactive--

When styling websites, one of the most versatile and intuitive ways to work with color is by using the HSL color model. HSL stands for Hue, Saturation, and Lightness — three key components that define a color. 

The HSL color model represents colors in a way that is more in line with how humans perceive color. In this lesson, we will explore what the HSL color model is and how the `hsl()` function is used in CSS.

The hue is the color type, represented as an angle on the color wheel, which ranges from `0` to `360` degrees. For example, `0` degrees represents red, `120` degrees is green, and `240` degrees is blue. By adjusting the hue, you shift through different colors on the spectrum.

Saturation refers to the intensity or purity of the color. It is measured as a percentage from `0%` (a completely desaturated, grayscale color) to `100%` (the most vibrant form of that color). A color with `100%` saturation is fully vivid, while a color with `0%` saturation appears as a shade of gray.

Lightness determines how light or dark the color is, again measured as a percentage. A lightness value of `0%` will produce black, `50%` will give you the normal tone of the hue, and `100%` will result in white.

In CSS, the `hsl()` function is used to define colors using the HSL color model. Here is the basic syntax:

```css
element {
  color: hsl(hue, saturation, lightness);
}
```

Let's break this down with an example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<p>This is a paragraph.</p>
```

```css
body {
  background-color: hsla(0, 0%, 1%, 1.00);
}

p {
  color: hsl(120, 100%, 50%);
}
```

:::

In this case, the hue is `120` degrees, which corresponds to green. The saturation is `100%`, so the green will be fully vivid. The lightness is `50%`, so it's at its normal tone — neither too dark nor too light. As a result, the text color of the paragraph will be a bright green.

One of the main advantages of the HSL color model is its intuitive nature. It makes it easy to adjust a color’s vibrancy or lightness by tweaking the saturation and lightness values without having to alter the core color (hue). 

For instance, if you want to create different shades or tints of the same color, you can simply adjust the lightness value.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="light">This is a light blue div.</div>
<div class="dark">This is a dark blue div.</div>
```

```css
div.light {
  background-color: hsl(240, 100%, 80%);
}

div.dark {
  background-color: hsl(240, 100%, 20%);
  color: hsl(0, 0%, 100%);
}
```

:::

Here, both `div` elements are using the same hue (`240` degrees, which is blue), but one has a lightness of `80%` (a lighter shade of blue), and the other has a lightness of `20%` (a darker shade of blue).

Just like the RGB model has an `rgba()` function to include transparency, the HSL model has an `hsla()` function. The fourth parameter in this function represents the alpha value, which controls the opacity of the color. Here is the basic syntax:

```css
element {
  background-color: hsla(hue, saturation, lightness, alpha);
}
```

Let's take a look at an example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div>This is a div.</div>
```

```css
div {
  background-color: hsla(0, 100%, 50%, 0.5);
}
```

:::

This code would give the `div` a semi-transparent red background, where the hue is set to `0` degrees (red), saturation is `100%`, lightness is `50%`, and alpha is `0.5` (50% opacity). You can also specify the alpha as a percentage — for example, `hsla(0, 100%, 50%, 50%)` is equivalent to `hsla(0, 100%, 50%, 0.5)`.

The HSL color model is particularly useful when you need to create color schemes and adjust shades or tints easily. 

Because HSL separates the hue from saturation and lightness, you can keep a consistent color theme while tweaking lightness for shadows or highlights. This level of flexibility makes HSL a favorite for designers and developers alike.

Additionally, HSL makes color values more readable and understandable when compared to other methods like hex codes or RGB. You can more clearly see the intent behind the color and adjust accordingly, especially when experimenting with different designs.

With the HSL color model, you gain more flexibility in controlling color tones, saturation, and lightness, making it a powerful tool for creating rich and dynamic designs in CSS.

# --questions--

## --text--

What does the first value in the hsl() function represent?

## --answers--

Saturation

### --feedback--

This value is measured in degrees and determines the type of color (e.g., red, blue, green).

---

Lightness

### --feedback--

This value is measured in degrees and determines the type of color (e.g., red, blue, green).

---

Hue

---

Opacity

### --feedback--

This value is measured in degrees and determines the type of color (e.g., red, blue, green).

## --video-solution--

3

## --text--

Which percentage value for lightness would result in pure white when using the HSL model?

## --answers--

`0%`

### --feedback--

Lightness refers to how light or dark a color appears.

---

`50%`

### --feedback--

Lightness refers to how light or dark a color appears.

---

`100%`

---

`25%`

### --feedback--

Lightness refers to how light or dark a color appears.

## --video-solution--

3

## --text--

How would you make a color semi-transparent using the HSL model?

## --answers--

By using `hsla()` and adjusting the alpha value.

---

By lowering the lightness value in the `hsl()` function/

### --feedback--

Consider how you control opacity in the HSL model.

---

By increasing the hue value above 360 degrees.

### --feedback--

Consider how you control opacity in the HSL model.

---

By setting the saturation value to `0%`.

### --feedback--

Consider how you control opacity in the HSL model.

## --video-solution--

1
