---
id: 672bc5344330d7bee2f9c2ed
title: What Are Hex Codes, and How Do They Work in CSS?
challengeType: 19
dashedName: what-are-hex-codes
---

# --interactive--

When working with CSS to style a webpage, one of the most common methods for defining colors is by using hex color values. Hexadecimal color values, or hex codes, are a concise way to represent colors in the RGB color model. In this lesson, we'll explore what hex codes are, how they work in CSS, and when to use them.

A hex code (short for hexadecimal code) is a six-character string used to represent colors in the RGB color model. The "hex" refers to the base-16 numbering system, which uses digits `0` to `9` and letters `A` to `F`. 

In the context of colors, hex codes specify the amounts of red, green, and blue (RGB) that make up a particular color. Each hex code starts with a hash symbol (`#`), followed by six characters that define the intensity of red, green, and blue in the color. 

For example, the hex code for black is `#000000`, and the hex code for white is `#FFFFFF`. The first two characters represent the red value, the next two represent green, and the last two represent blue.

In CSS, you can apply colors to elements by using hex codes. Here is the basic syntax:

```css
element {
  color: #RRGGBB;
}
```

Here, `#RRGGBB` is a placeholder for the actual hex code. The `RR`, `GG`, and `BB` pairs each represent the intensity of red, green, and blue, respectively. 

These pairs can range from `00` (the lowest intensity) to `FF` (the highest intensity). The higher the number, the more of that color will be present in the final mix. For example, let's apply some hex colors to a few elements:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<h1>This is a heading.</h1>
<p>This is a paragraph.</p>
```

```css
h1 {
  color: #FF5733; /* A reddish-orange color */
}
p {
  background-color: #4CAF50; /* A shade of green */
}
```

:::

In the first case, `#FF5733` is a reddish-orange color. Here’s the breakdown:

- `FF` is the highest value for red (fully saturated).
- `57` is a moderate amount of green.
- `33` is a small amount of blue.

In the second case, `#4CAF50` is a shade of green:

- `4C` is a low value for red.
- `AF` is a strong value for green.
- `50` is a moderate value for blue.

Hex codes are popular because they are precise and easy to use. They allow you to fine-tune your colors, making them ideal for designs where consistency is important. 

Most design software, such as Adobe Photoshop or Figma, provides hex codes for the colors you select, which makes it easy to copy and paste these values directly into your CSS files.

In web development, hex codes are often used for defining text colors, backgrounds, borders, and other visual elements. For example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<button>Example</button>
```

```css
body {
  background-color: #F0F0F0; /* Light gray background */
}

button {
  background-color: #007BFF; /* A shade of blue */
  color: #FFFFFF; /* White text */
}
```

:::

This ensures that your colors remain consistent across your entire website or application.

In some cases, you may notice hex codes written in shorthand format, using only three characters instead of six. This is possible when both characters in each color pair are the same. For instance, `#FF5733` cannot be shortened, but `#FFFFFF` (white) can be written as `#FFF`.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<h2>This is a heading.</h2>
```

```css
body {
  background-color: #000;
}

h2 {
  color: #FFF; /* White in shorthand */
}
```

:::

The shorthand `#FFF` is equivalent to `#FFFFFF`. Similarly, `#000` would represent black which is `#000000` in full form.

Hex codes are popular for their precision and compatibility, allowing for over 16 million colors across all browsers. They're ideal when you need specific branding colors, want to control exact shades that aren't easily defined by named colors or HSL, or when you're copying colors from design software that provides hex codes by default.

# --questions--

## --text--

What does each pair of characters in a hex code represent?

## --answers--

The amount of opacity in the color.

### --feedback--

Think about how hex codes break down colors into the RGB color model.

---

The intensity of red, green, or blue in the color.

---

The amount of contrast between colors.

### --feedback--

Think about how hex codes break down colors into the RGB color model.

---

The lightness and saturation of the color.

### --feedback--

Think about how hex codes break down colors into the RGB color model.

## --video-solution--

2

## --text--

How would you write the hex code for black using the shorthand format?

## --answers--

`#000`

---

`#000000`

### --feedback--

Consider how shorthand hex codes condense the full six-character code.

---

`#FFF`

### --feedback--

Consider how shorthand hex codes condense the full six-character code.

---

`#FFFFFF`

### --feedback--

Consider how shorthand hex codes condense the full six-character code.

## --video-solution--

1

## --text--

Why might a designer choose to use hex codes in their CSS over named colors?

## --answers--

Hex codes allow for more precise color selection.

---

Hex codes are easier to remember than named colors.

### --feedback--

Think about the limitations of named colors and the flexibility offered by hex codes.

---

Hex codes automatically adjust for light and dark mode.

### --feedback--

Think about the limitations of named colors and the flexibility offered by hex codes.

---

Hex codes do not require any formatting in CSS.

### --feedback--

Think about the limitations of named colors and the flexibility offered by hex codes.

## --video-solution--

1
