---
id: 672bc544196a17bf28594e64
title: What Are Linear and Radial Gradients, and How Do They Work in CSS?
challengeType: 19
dashedName: what-are-linear-and-radial-gradients
---

# --interactive--

In a previous lesson, you learned how to start working with linear and radial gradients. In this lesson, we are going to dive deeper into how to work with the CSS properties to create more visually appealing and complex designs.

Gradients in CSS allow you to create smooth transitions between two or more specified colors. They are often used to add depth, texture, and visual interest to web designs without the need for image files. 

CSS supports two main types of gradients: linear gradients and radial gradients.

Linear gradients create a gradual blend between colors along a straight line. You can control the direction of this line and the colors used. Here's a basic example of a linear gradient:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="linear-gradient"></div>
```

```css
.linear-gradient {
  background: linear-gradient(to right, red, blue);
  height: 40vh;
}
```

:::

This creates a gradient that transitions from red on the left to blue on the right. The `to right` parameter specifies the direction of the gradient. You can use other directions like `to left`, `to top`, `to bottom`, or even specify angles like `45deg`.

You can also use multiple color stops in a linear gradient:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="multi-color-gradient"></div>
```

```css
.multi-color-gradient {
  background: linear-gradient(to right, red, yellow, blue);
  height: 40vh;
}
```

:::

This creates a gradient that transitions from red to yellow to blue, evenly spaced across the element.

Radial gradients, on the other hand, create circular or elliptical gradients that radiate from a central point. Here's an example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="radial-gradient"></div>
```

```css
.radial-gradient {
  background: radial-gradient(circle, red, blue);
  height: 40vh;
}
```

:::

This creates a circular gradient that starts with red in the center and transitions to blue at the edges. You can also specify the shape and size of radial gradients:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="custom-radial-gradient"></div>
```

```css
.custom-radial-gradient {
  background: radial-gradient(ellipse at top left, red, blue);
  height: 40vh;
}
```

:::

This creates an elliptical gradient starting from the top left corner of the element. Both linear and radial gradients allow you to specify color stops at precise positions. For example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css" />
<div class="precise-gradient"></div>
```

```css
.precise-gradient {
  background: linear-gradient(to right, red 20%, yellow 40%, blue 80%);
  height: 40vh;
}
```

:::

This creates a gradient where red takes up the first `20%`, then transitions to yellow at `40%`, and finally to blue at `80%`.

Gradients can be used wherever you'd use an image in CSS. This makes them versatile for creating backgrounds, buttons, or even text effects when combined with other CSS properties.

Remember, while gradients can enhance the visual appeal of your website, it's important to ensure sufficient contrast for accessibility, especially when using gradients behind text.

# --questions--

## --text--

What is the difference between linear and radial gradients in CSS?

## --answers--

Linear gradients use only two colors, while radial gradients use multiple colors.

### --feedback--

Think about the shape and direction of each type of gradient.

---

Linear gradients transition along a straight line, while radial gradients radiate from a central point.

---

Linear gradients are only horizontal, while radial gradients can be any shape.

### --feedback--

Think about the shape and direction of each type of gradient.

---

Linear gradients are smoother than radial gradients.

### --feedback--

Think about the shape and direction of each type of gradient.

## --video-solution--

2

## --text--

In the following CSS code, what does 45deg specify?

```css
{
  background: linear-gradient(45deg, red, blue);
}
```

## --answers--

The angle of rotation for the entire element.

### --feedback--

Consider how this value might affect the direction of the color transition.

---

The direction of the gradient line.

---

The size of the gradient.

### --feedback--

Consider how this value might affect the direction of the color transition.

---

The distance between color stops.

### --feedback--

Consider how this value might affect the direction of the color transition.

## --video-solution--

2

## --text--

Which of the following is NOT a valid way to specify direction in a linear gradient?

## --answers--

`to right`

### --feedback--

Think about the standard keywords and values used for specifying gradient directions.

---

`to bottom left`

### --feedback--

Think about the standard keywords and values used for specifying gradient directions.

---

`90deg`

### --feedback--

Think about the standard keywords and values used for specifying gradient directions.

---

`diagonal`

## --video-solution--

4
