---
id: 67329f64e0ef5c5b7388158d
title: How Do You Get the Index for an Element in an Array Using the indexOf Method?
challengeType: 19
dashedName: how-do-you-get-the-index-for-an-element-in-an-array-using-the-indexof-method
---

# --interactive--

In JavaScript, the `indexOf()` method is useful for finding the first index of a specific element within an array. If the element cannot be found, then it will return `-1`. Here is the basic syntax:

```js
array.indexOf(element, fromIndex)
```

`element` represents the value you want to search for within the array, and the `fromIndex` parameter is the position from which the search should start. The `fromIndex` parameter is optional. If `fromIndex` is not provided, the search starts from the beginning of the array. Let's look at an example:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange", "banana"];
let index = fruits.indexOf("banana");
console.log(index); // 1
```

:::

In this example, we have an array `fruits` containing various fruit names. We use the `indexOf()` method to find the index of the string `banana` within the `fruits` array. Since `banana` is present at index `1`, the method returns `1`, which is stored in the `index` variable and logged to the console.

If the element you're searching for is not found in the array, `indexOf()` returns `-1`. For example:

:::interactive_editor

```js
let fruits = ["apple", "banana", "orange"];
let index = fruits.indexOf("grape");
console.log(index); // -1
```

:::

Here, we search for the string `grape` in the fruits array using `indexOf()`. Since `grape` is not present in the array, the method returns `-1`, which is stored in the `index` variable and logged to the console.

If you want to start looking for an item after a specific index number, then you can pass a second argument like in this example: 

:::interactive_editor

```js
let colors = ["red", "green", "blue", "yellow", "green"];
let index = colors.indexOf("green", 3);
console.log(index); // 4
```

:::

In this example, the search does not start from the start of an array, rather it starts from the index number `3` which is `yellow` and gets the output of `4`.

# --questions--

## --text--

What will be the output of the following code?

```js
let numbers = [10, 20, 30, 20, 40];
let index = numbers.indexOf(20);
console.log(index);
```

## --answers--

`0`

### --feedback--

The `indexOf()` method returns the index of the first occurrence of the given element in the array.

---

`1`

---

`2`

### --feedback--

The `indexOf()` method returns the index of the first occurrence of the given element in the array.

---

`3`

### --feedback--

The `indexOf()` method returns the index of the first occurrence of the given element in the array.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let fruits = ["apple", "banana", "orange", "grape"];
let index = fruits.indexOf("kiwi");
console.log(index);
```

## --answers--

`0`

### --feedback--

The `indexOf()` method returns `-1` if the given element is not found in the array.

---

`-1`

---

`undefined`

### --feedback--

The `indexOf()` method returns `-1` if the given element is not found in the array.

---

An error will occur.

### --feedback--

The `indexOf()` method returns `-1` if the given element is not found in the array.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let colors = ["red", "green", "blue", "yellow", "green"];
let index = colors.indexOf("green", 2);
console.log(index);
```

## --answers--

`1`

### --feedback--

The `indexOf()` method can take a second argument to specify the starting index for the search.

---

`2`

### --feedback--

The `indexOf()` method can take a second argument to specify the starting index for the search.

---

`4`

---

`-1`

### --feedback--

The `indexOf()` method can take a second argument to specify the starting index for the search.

## --video-solution--

3
