---
id: 673271dffbc34fda31da9515
title: What Are Comparison Operators, and How Do They Work?
challengeType: 19
dashedName: what-are-comparison-operators-and-how-do-they-work
---

# --interactive--

Comparison operators allow you to compare two values and return a `true` or `false` result. You can then use the result to make a decision or control the flow of your program. You use comparisons in `if` statements, loops, and many other situations where you need to make decisions based on certain conditions. Let's dive into the most common comparison operators and see how they work.

The greater than operator, represented by a right-angle bracket (`>`), checks if the value on the left is greater than the one on the right:

:::interactive_editor

```js
let a = 6;
let b = 9;

console.log(a > b); // false
console.log(b > a); // true
```

:::

The greater than or equal operator, represented by a right-angle bracket and the equals sign (`>=`), checks if the value on the left is either greater than or equal to the one on the right:

:::interactive_editor

```js
let a = 6;
let b = 9;
let c = 6;

console.log(a >= b); // false
console.log(b >= a); // true
console.log(a >= c); // true
```

:::

The lesser than operator, represented by a left-angle bracket (`<`) works similarly to `>`, but in reverse. It checks if the value on the left is smaller than the one on the right:

:::interactive_editor

```js
let a = 6;
let b = 9;

console.log(a < b); // true
console.log(b < a); // false
```

:::

The less than or equal operator, represented by a left-angle bracket and the equals sign (`<=`) checks if the value on the left is smaller than or equal to the one on the right:

:::interactive_editor

```js
let a = 6;
let b = 9;
let c = 6;

console.log(a <= b); // true
console.log(b <= a); // false
console.log(a <= c); // true
```

:::

# --questions--

## --text--

What does the greater than or equals (`>=`) operator do in JavaScript?

## --answers--

It checks if the value on the left is strictly greater than the one on the right.

### --feedback--

Think about how the greater than or equals operator combines two comparisons into one.

---

It checks if the value on the left is either greater than or equal to the one on the right.

---

It checks if the value on the right is greater than the one on the left.

### --feedback--

Think about how the greater than or equals operator combines two comparisons into one.

---

It checks if both values are equal.

### --feedback--

Think about how the greater than or equals operator combines two comparisons into one.

## --video-solution--

2

## --text--

Where would you typically use comparison operators in JavaScript?

## --answers--

Only in arithmetic operations.

### --feedback--

Think about when you need to check conditions in your code.

---

In if statements, loops, and other situations requiring decisions based on conditions.

---

Only when working with strings.

### --feedback--

Think about when you need to check conditions in your code.

---

When defining functions.

### --feedback--

Think about when you need to check conditions in your code.

## --video-solution--

2

## --text--

Which two operators in JavaScript avoid type coercion?

## --answers--

`==` and `!=`.

### --feedback--

Think about the operators that compare both value and type.

---

`===` and `!==`.

---

`>` and `<`.

### --feedback--

Think about the operators that compare both value and type.

---

`<=` and `>=`.

### --feedback--

Think about the operators that compare both value and type.

## --video-solution--

2
