---
id: 673271fd11d063daf0cf8d20
title: What Are Conditional Statements, and How Do If/Else If/Else Statements Work?
challengeType: 19
dashedName: what-are-conditional-statements-and-how-do-if-else-if-else-statements-work
---

# --interactive--

Conditional statements let you make decisions in your JavaScript code. They allow your program to flow in a particular way based on certain conditions. Let's take a look at how `if`, `else if`, `else`, and the ternary operator work to let you control the flow of your code.

An `if` statement takes a condition and runs a block of code if that condition is truthy. Truthy values are any values that result in `true` when evaluated in a Boolean context like an `if` statement. Here are examples of truthy values:

- non-empty strings, for example, `hello`

- any number other than `0` and `-0`, for example, `4`, `-5`, and others

- arrays

- objects

- the boolean `true`

On the other hand, falsy values are values that evaluate to `false` in a boolean context. JavaScript has few falsy values, which makes them easy to remember. Here are a few falsy values:

- boolean `false`

- `0` (zero)

- `""` (empty string)

- `null`

- `undefined`

- `NaN` (Not a Number)

Now, that we have a basic understanding of truthy and falsy values, let's see how it works with `if` statements. In this first example, we are using a couple of `if` statements to check against truthy and falsy values:

:::interactive_editor

```js
if (null) {
  console.log("This will not run.");
}

if ("freeCodeCamp") {
  console.log("This will run.");
}
```

:::

Since `null` is a falsy value, the message inside the block will never be logged to the console. But for the second `if` statement, the string `freeCodeCamp` is a truthy value, and will be considered `true` in this boolean context of the `if` statement. As a result, the message `This will run.` will be logged to the console.

Let's take a look at a few more examples on how `if` statements work with different comparison operators. Here is an example of using an `if` statement to check if the user is eligible to vote: 

:::interactive_editor

```js
const age = 22;

if (age >= 18) {
 console.log("You're eligible to vote"); // You're eligible to vote
}
```

:::

In this example, since `age` is currently `22`, this means the condition will evaluate to `true` because `22` is greater than or equal to `18`. So the message `You're eligible to vote` will be logged to the console. If we change the example so `age` is now `15`, then the condition will evaluate to `false` and the message will not be logged to the console:

:::interactive_editor

```js
const age = 15;

if (age >= 18) {
 console.log("You're eligible to vote"); // Code not running because age is less than 18
}
```

:::

When a condition is `false`, then you can use an `else` clause:

:::interactive_editor

```js
const age = 15;

if (age >= 18) {
 console.log("You're eligible to vote");
} else {
 console.log("You're not eligible to vote"); // You're not eligible to vote
}
```

:::

In this example, `15` is not greater than or equal to `18`, so the condition would be `false`. The code inside the `else` block will run in this case.

If you want to check multiple conditions, you can use an `else if` block. This allows your program to choose between more than two paths.

:::interactive_editor

```js
const score = 87;

if (score >= 90) {
 console.log('You got an A'); 
} else if (score >= 80) {
 console.log('You got a B'); // You got a B
} else if (score >= 70) {
 console.log('You got a C');
} else {
 console.log('You failed! You need to study more!');
}
```

:::

Since the `score` is currently `87`, then the message of `You got a B` would be logged to the console.

The ternary operator is a compact way to write simple `if/else` statements. It has three parts: a condition, a result if the condition is true, and a result if it is false. Here's the basic syntax:

```js
condition ? expressionIfTrue : expressionIfFalse;
```

Here's an example dealing with weather temperatures in Celsius: 

:::interactive_editor

```js
const temperature = 30;
const weather = temperature > 25 ? 'sunny' : 'cool';

console.log(`It's a ${weather} day!`);
```

:::

If `temperature` is greater than `25`, the code above logs `It's a sunny day!`. If `temperature` is ever less than `25`, it logs `It's a cool day!`.

So, which should you use between an if statement and a ternary? Use a ternary while dealing with a single condition or single expressions, or when you want a compact syntax for simple logic. Use `if/else` statements when you're dealing with complex conditions and multiple statements, as things become unreadable if you nest ternaries. 

# --questions--

## --text--

What's a compact way to write simple `if`/`else` statements?

## --answers--

Using the `switch` statement.

### --feedback--

Think of a one-liner for conditional logic.

---

Using a `while` loop.

### --feedback--

Think of a one-liner for conditional logic.

---

Using multiple `if` statements.

### --feedback--

Think of a one-liner for conditional logic.

---

Using the ternary operator.

## --video-solution--

4

## --text--

How can you check for multiple conditions in an `if` statement?


## --answers--

By using a `switch` statement only.

### --feedback--

Think about how to handle more than two possible outcomes.

---

By using a `while` loop.

### --feedback--

Think about how to handle more than two possible outcomes.

---

By using an `else if` block to choose between more than two paths.

---

By using the ternary operator.

### --feedback--

Think about how to handle more than two possible outcomes.

## --video-solution--

3

## --text--

What is the purpose of the `else` block in an `if` statement?

## --answers--

It runs when the condition in the `if` statement is `true`.

### --feedback--

Think about what happens when the `if` condition is `false`.

---

It runs a block of code when the condition in the `if` statement is not `true`.

---

It checks if multiple conditions are `true`.

### --feedback--

Think about what happens when the `if` condition is `false`.

---

It always runs before the `if` block.

### --feedback--

Think about what happens when the `if` condition is `false`.

## --video-solution--

2
