---
id: 672aa80bc17f355fabd2e9e8
title: What Are the Fundamentals of Typography?
challengeType: 19
dashedName: what-are-the-fundamentals-of-typography
---

# --description--

Typography is the art of choosing the right fonts and format to make text visually appealing and easy to read. "Type" refers to how the individual characters are designed and arranged. By choosing the right fonts for your project, you can evoke emotions, establish hierarchy, and reinforce your brand's identity.

We'll start by talking about typefaces and fonts. A typeface is the overall design and style of a set of characters, numbers, and symbols. It's like a blueprint for a family of fonts. A font is a specific variation of a typeface with specific characteristics, such as size, weight, style, and width.

Two very important examples of typefaces are Serif and Sans Serif. The Serif typeface has a classical style with small lines at the end of characters. Serif typefaces are commonly used for printed materials, like books. Some examples are Times New Roman, Georgia, and Garamond. 

In contrast, the Sans Serif typeface has a more modern look, without the small lines at the end of characters. Sans Serif typefaces are commonly used in digital design because they are easy to read on screen. Some examples include Helvetica, Arial, and Roboto. There are other typeface classifications, like Script, Blackletter, Monospaced, and Decorative.

We mentioned that typefaces are like blueprints for fonts, right? Well, fonts can also be grouped if they share a similar design. Different weights and styles can be combined. For example, Times New Roman includes variations like Times New Roman Bold, Times New Roman Italic, and Times New Roman Bold Italic. These variations within the same font family typically include:

- Weight: The thickness of the characters, including light, regular, bold, and black.
- Style: The slant and orientation of the characters, like italic and oblique.
- Width: The horizontal space occupied by characters, condensed and expanded.

Great. Now let's explore the fundamental elements of typography:

- The baseline is the imaginary line on which most characters rest. 
- The cap height is the height of uppercase letters, measured from the baseline to the top. 
- The x-height is the average height of lowercase letters, excluding ascenders and descenders.
- Ascenders are the parts of lowercase letters that extend above the x-height, such as the tops of the letters `h`, `b`, `d`, and `f`.
- Descenders are the parts of lowercase letters that extend below the baseline, such as the tails of `y`, `g`, `p`, and `q`.

There are more advanced concepts too, like kerning, tracking, and leading.

Kerning is how space is adjusted between specific pairs of characters to improve their readability and aesthetics. For example, reducing the space between the letters `A` and `V`. Tracking is how space is adjusted between all characters in a block of text. It's essentially the distance between the characters. It affects how dense and open the text will be. Leading is the vertical space between lines of text. It's measured from the baseline of one line to the baseline of the next line.

Being familiar with these concepts is essential for choosing the right font for your project. 

Line length can also have a significant impact on readability. If the text is too narrow, readers will need to refocus too often. If the text is too wide, they may experience fatigue. You should find the optimal line length for comfortable reading.

With typography, you can also create a visual hierarchy, helping readers understand what parts of the text or user interface are most important. Larger fonts usually indicate that text is more important. Making the text bold is also helpful for emphasizing it.

Underlining text or presenting it in italics is helpful for highlighting key points. Providing accurate spacing around the text can highlight its importance. And color contrast can bring readers' attention to specific parts of the text.

Having basic knowledge of typography is essential for designing visually engaging applications. By understanding fonts, spacing, and hierarchy, you can create visual experiences that enhance the readability of your content and reinforce your brand's identity

# --questions--

## --text--

Which of the following refers to how the individual characters are designed and arranged?

## --answers--

Glyph

### --feedback--

Review the beginning of the lesson for the answer.

---

Type

---

Beak

### --feedback--

Review the beginning of the lesson for the answer.

---

Shoulder

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

2

## --text--

What is the difference between a typeface and a font?

## --answers--

A typeface is a specific style of a font, while a font is the overall design.

### --feedback--

Think about the relationship between a car model and a specific car.

---

A font is a specific style of a typeface, while a typeface is the overall design.

---

There is no difference between a typeface and a font.

### --feedback--

Think about the relationship between a car model and a specific car.

---

A typeface is a collection of fonts, while a font is a single character.

### --feedback--

Think about the relationship between a car model and a specific car.

## --video-solution--

2

## --text--

What is the main difference between serif and sans-serif fonts?

## --answers--

Serif fonts are handwritten, while sans-serif fonts are printed.

### --feedback--

Focus on the visual characteristics of the fonts.

---

Serif fonts have small lines at the end of characters, while sans-serif fonts do not.

---

Serif fonts are used for headlines, while sans-serif fonts are used for body text.

### --feedback--

Focus on the visual characteristics of the fonts.

---

Serif fonts are older than sans-serif fonts.

### --feedback--

Focus on the visual characteristics of the fonts.

## --video-solution--

2

