---
id: 672bd81ee07c43fd2070f0fe
title: What Are Web Safe Fonts?
challengeType: 19
dashedName: what-are-web-safe-fonts
---

# --description--

Web-safe fonts are a subset of fonts that are very likely to be installed on a computer or device. They are widely supported across different operating systems and web browsers, so it's very likely that they will be rendered and displayed consistently. Let's see how this works.

Browsers are responsible for interpreting and displaying fonts on a website. When the browser has to render a font, it tries to find the font file on the user's system. But if the font is not found, it will usually fall back to a default system font. This ensures that the content is still readable, even if the specific font that should be rendered on the website is missing.

However, the fallback font selected by the browser may look very different from the font that was originally supposed to be rendered. This can have a critical impact on the overall design and user experience. To avoid this, you should use web-safe fonts whenever possible. You have two options. You can either use them as your primary fonts or you can use custom fonts with a web-safe font as a fallback option. This way, you can control how the website will look in case the custom font is not found.

Let's check out some examples of web-safe fonts. In a previous lesson, you learned that sans-serif fonts are commonly used for web development because they don't have small "feet" or lines at the end of the characters, so they're easy to read on screen. Some examples of web-safe sans-serif fonts are:

- Arial
- Verdana
- Trebuchet MS

In contrast, serif fonts do have small "feet" at the end of the characters, so they're commonly used for traditional print. But if you ever need to use them for web development purposes, web-safe serif fonts include:

- Times New Roman
- Georgia

By using web-safe fonts, you can make sure that your design looks consistent across devices and platforms. They can also enhance accessibility for users with visual disabilities, since they are simple and easy to read. And finally, web-safe fonts can reduce page load time, since they don't have to be downloaded if they're already installed.

Now that you know what web-safe fonts are, you can start using them and assigning them as fallbacks to create reliable user experiences across browsers and platforms.

# --questions--

## --text--

Which of the following is a key characteristic of web-safe fonts?

## --answers--

They are difficult to read.

### --feedback--

Think about the primary advantage of using web-safe fonts.

---

They are designed for specific types of content.

### --feedback--

Think about the primary advantage of using web-safe fonts.

---

They are widely supported across different platforms and browsers.

---

They are only available in serif styles.

### --feedback--

Think about the primary advantage of using web-safe fonts.

## --video-solution--

3

## --text--

Which of the following is not a web-safe font?

## --answers--

`Arial`

### --feedback--

Think about the most common fonts used on the web.

---

`Verdana`

### --feedback--

Think about the most common fonts used on the web.

---

`Georgia`

### --feedback--

Think about the most common fonts used on the web.

---

`Dancing Script`

## --video-solution--

4

## --text--

When are web-safe fonts particularly useful?

## --answers--

For complex and visually demanding web designs.

### --feedback--

Think about the situations where a reliable and universally supported font is needed.

---

When a specific custom font is essential for branding purposes.

### --feedback--

Think about the situations where a reliable and universally supported font is needed.

---

For basic web design and when consistent rendering is a priority.

---

For creating custom fonts.

### --feedback--

Think about the situations where a reliable and universally supported font is needed.

## --video-solution--

3
