---
id: 672bd8453d1371fdb1510fe5
title: How Do You Work with External Fonts Like Font Squirrel and Google Fonts?
challengeType: 19
dashedName: how-do-you-work-with-external-fonts-like-font-squirrel-and-google-fonts
---

# --interactive--

An external font is a font file that is not included directly within your project files. They're usually hosted on a separate server. A server is a computer that provides data or services to other computers over a network. You will learn more about servers in future lessons. External fonts give you more flexibility because you can use custom fonts that may not be installed on the user's device.

Google Fonts and Font Squirrel are popular online resources for finding and using free fonts for web development purposes. You can incorporate them into your projects very easily.

Let's start with Google Fonts. This is a Google service that offers a collection of fonts, many of which are designed specifically for web development. On the Google Fonts user interface, you can see many different elements. Let's go through them one by one. On the left sidebar, you will find:

- A section to see, find, and filter fonts.
- A special section on Noto, a collection of high-quality fonts with various weights, widths, and styles that are perfect for communicating in more than 1,000 languages and over 150 writing systems.
- A section where you can find and download icons for your web projects.
- A section where you can learn more about fonts and their best practices, followed by frequently asked questions.

To add a Google Font to your website, you should go to the first section (Fonts). You can customize the preview text on the left sidebar, where it says "Preview." Just write the text that you would like to see and it will be updated automatically. This is helpful to preview the font with the text that you already have in mind for your website. You can also adjust the font size and filter the fonts based on their characteristics. 

To see more information about a font, just click on it and you will see important information about the font, like who designed it, preview text, and different styles, like light, regular, medium, bold, and black. If you click on the options at the top, you can go to the type tester, see individual glyphs, and learn more about the font and its license.

You can customize the font size of the preview text with the blue slider located next to the field where you can enter the preview text. Once you're ready to add the font to your project, click on the blue "Get font" button at the top. You'll be taken to a summary page where you'll see the fonts that you currently have selected. You can have multiple fonts selected simultaneously.

Next, you have to choose if you would like to download the font files to add them to your project as local files or if you would like to use them as external fonts and download them from Google's servers when a user enters your website. Click on "Download all" if you want to download them but if you prefer to use them as external fonts on Google's servers, click on "Get embed code." If you click on "Get embed code," you'll see the instructions that you should follow to add these external fonts to your project.

For web development projects, you have two options. You can either use a `link` element or `@import`. If you choose the `link` element option, you can copy and paste the HTML snippet and the CSS rules to add them to your project. You should embed the code in the `head` element of your HTML file and add the CSS rules that fit your needs. 

Here is an example of using all Roboto styles:

:::interactive_editor

```html
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="styles.css">

<p class="roboto-thin">roboto-thin</p>
<p class="roboto-light">roboto-light</p>
<p class="roboto-regular">roboto-regular</p>
<p class="roboto-medium">roboto-medium</p>
<p class="roboto-bold">roboto-bold</p>
<p class="roboto-black">roboto-black</p>

<p class="roboto-thin-italic">roboto-thin-italic</p>
<p class="roboto-light-italic">roboto-light-italic</p>
<p class="roboto-regular-italic">roboto-regular-italic</p>
<p class="roboto-medium-italic">roboto-medium-italic</p>
<p class="roboto-bold-italic">roboto-bold-italic</p>
<p class="roboto-black-italic">roboto-black-italic</p>
```

```css
.roboto-thin {
  font-family: "Roboto", sans-serif;
  font-weight: 100;
  font-style: normal;
}

.roboto-light {
  font-family: "Roboto", sans-serif;
  font-weight: 300;
  font-style: normal;
}

.roboto-regular {
  font-family: "Roboto", sans-serif;
  font-weight: 400;
  font-style: normal;
}

.roboto-medium {
  font-family: "Roboto", sans-serif;
  font-weight: 500;
  font-style: normal;
}

.roboto-bold {
  font-family: "Roboto", sans-serif;
  font-weight: 700;
  font-style: normal;
}

.roboto-black {
  font-family: "Roboto", sans-serif;
  font-weight: 900;
  font-style: normal;
}

.roboto-thin-italic {
  font-family: "Roboto", sans-serif;
  font-weight: 100;
  font-style: italic;
}

.roboto-light-italic {
  font-family: "Roboto", sans-serif;
  font-weight: 300;
  font-style: italic;
}

.roboto-regular-italic {
  font-family: "Roboto", sans-serif;
  font-weight: 400;
  font-style: italic;
}

.roboto-medium-italic {
  font-family: "Roboto", sans-serif;
  font-weight: 500;
  font-style: italic;
}

.roboto-bold-italic {
  font-family: "Roboto", sans-serif;
  font-weight: 700;
  font-style: italic;
}

.roboto-black-italic {
  font-family: "Roboto", sans-serif;
  font-weight: 900;
  font-style: italic;
}
```

:::

There's a CSS rule for each font style. Each rule assigns the custom fonts with fallback fonts in case the custom fonts are not loaded properly.

If you choose the `@import` option instead, you will need to add that rule to your CSS file. Here is an example:

```css
@import url('https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');
```

The CSS rules are exactly the same.

If you only want to include specific font styles, you also have the option to remove them from these snippets. The HTML and CSS snippets will be updated automatically. 

And this is Google Fonts. It's one of the most popular options for finding free and open source fonts for web development projects.

Another great option is Font Squirrel, where you can find and download the custom fonts that you envision for your design. If you search for a font and click on a result, you'll see more details about the font, including specimens, test drive, glyphs, and Webfont kit. You can also see samples of the different styles and variations of the font, like thin, light, medium, bold, and black.

Once you've decided on a font that you want to use in your project, go to the "Webfont Kit" tab. Here, you can check if the font's license allows you to use it in `@font-face` CSS embeddings. You can also choose the subset and format.

Clicking on the "Download @font-face Kit" button will download a compressed (zip) file. If you unzip it, you'll find a "web fonts" folder, the license as a text file, and an HTML file with instructions on how to use web fonts. The web fonts folder will have all the font files that you need for your project. You will find them grouped into specific folders for the different fonts styles.

If you open the HTML file on a browser, it has instructions on how to add the fonts to your project, how to include them in the stylesheet with the `@font-face` declaration, and how to use them in the CSS rules.

This is how you can add custom Font Squirrel fonts to your project. You can also host them on a separate server and use them as external fonts. External fonts are very helpful for customizing the overall look and design of your website. They can make your website truly unique.

However, you should also keep in mind that using multiple external fonts can increase the load time of the website, affecting its overall performance. You should always strive to find a balance between style and efficiency.

# --questions--

## --text--

What is the primary advantage of using external fonts from services like Font Squirrel or Google Fonts?

## --answers--

Reduced font file size.

### --feedback--

Think about how external font services can benefit your web design.

---

Increased font rendering speed.

### --feedback--

Think about how external font services can benefit your web design.

---

Expanded font selection and variety.

---

Improved browser compatibility.

### --feedback--

Think about how external font services can benefit your web design.

## --video-solution--

3

## --text--

What is a potential drawback of using multiple external fonts?

## --answers--

Increased website load time.

---

Increased likelihood of bugs.

### --feedback--

Think about the challenges that might arise when relying on multiple external resources.

---

Limited customization options.

### --feedback--

Think about the challenges that might arise when relying on multiple external resources.

---

Increased browser compatibility.

### --feedback--

Think about the challenges that might arise when relying on multiple external resources.

## --video-solution--

1

## --text--

What is the importance of providing fallback fonts when using external fonts?

## --answers--

To create a more visually appealing design.

### --feedback--

Consider what happens if the external font is not available.

---

To improve font rendering performance.

### --feedback--

Consider what happens if the external font is not available.

---

To display the text correctly, even if the external font is not loaded properly.

---

To reduce file size.

### --feedback--

Consider what happens if the external font is not available.

## --video-solution--

3
