---
id: 6732268d05c3661d32a0fee8
title: How Can You Repeat Track Listings in a Grid Layout?
challengeType: 19
dashedName: how-can-you-repeat-track-listings-in-a-grid-layout
---

# --interactive--

In the previous lessons, we have been working with the `grid-template-columns` property and setting the value to a few fractional units.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div class="box"></div>
  <div class="box"></div>
  <div class="box"></div>
  <div class="box"></div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: 1fr 1fr 1fr 1fr;
  column-gap: 10px;
}

.box {
  width: 100px;
  height: 100px;
  background-color: darkblue;
}
```

:::

While the following code is completely valid, there is an easier way to repeat a section or all of your track listings.

The `repeat()` function is used to repeat a section or all of the tracks for columns or rows. This function takes in a repeat count and the tracks you wish to repeat.

Here is a revised version of the earlier example using the repeat function:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div class="box"></div>
  <div class="box"></div>
  <div class="box"></div>
  <div class="box"></div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: repeat(4, 1fr);
  column-gap: 10px;
}

.box {
  width: 100px;
  height: 100px;
  background-color: darkblue;
}
```

:::

There won't be a change for the styles in the browser, but this is a more concise way to write repeated values for the columns.

The `repeat()` function will accept any valid pattern that you can use for rows or columns.

Here is an example using the `repeat()` function to set the first and third columns to 20 pixels and the second and fourth columns to one fractional unit.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div class="box"></div>
  <div class="box"></div>
  <div class="box"></div>
  <div class="box"></div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: repeat(2, 20px 1fr);
  column-gap: 10px;
}

.grid-container div {
  height: 100px;
  background-color: darkblue;
}
```

:::

Sometimes, you might opt to write out each individual value instead of using the `repeat()` function. But there are times when this function comes in handy, especially when you want to repeat a particular pattern for a track listing.

# --questions--

## --text--

Which of the following is the correct syntax for repeating track listings?

## --answers--

```css
.grid-container {
  display: grid;
  grid-template-columns: repeat(1fr times 4);
  column-gap: 10px;
}
```

### --feedback--

Review the beginning of the lesson where this was discussed.

---

```css
.grid-container {
  display: grid;
  grid-template-columns: repeat(4, 1fr);
  column-gap: 10px;
}
```

---

```css
.grid-container {
  display: grid;
  grid-template-columns: multiply(4, 1fr);
  column-gap: 10px;
}
```

### --feedback--

Review the beginning of the lesson where this was discussed.

---

```css
.grid-container {
  display: grid;
  grid-template-columns: repeatSections(4, 1fr);
  column-gap: 10px;
}
```

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

2

## --text--

What is the primary benefit of using the `repeat()` function in the `grid-template-columns` property?

## --answers--

It allows repeating column definitions more concisely and reduces redundancy.

---

It makes the code run faster.


### --feedback--

Think about how this property reduces repetition.

---

It leads to error free code.

### --feedback--

Think about how this property reduces repetition.

---

It makes the web page more responsive.

### --feedback--

Think about how this property reduces repetition.

## --video-solution--

1

## --text--

What is the result of setting `grid-template-columns` to `repeat(2, 20px 1fr);`?

## --answers--

It creates four columns all set to `1fr` wide.

### --feedback--

Review the end of the lesson where this was discussed.

---

It creates two columns where each is set to `20px` wide.

### --feedback--

Review the end of the lesson where this was discussed.

---

It creates four columns where the first and third are `20px` wide, and the second and fourth are `1fr` wide.

---

It creates three columns where the first and second are `20px` wide, and the third is `fr` wide.

### --feedback--

Review the end of the lesson where this was discussed.

## --video-solution--

3
