---
id: 673226a62eb2121da41a3d68
title: What Is the minmax() Function and How Does It Work?
challengeType: 19
dashedName: what-is-the-minmax-function-and-how-does-it-work
---

# --interactive--

The `minmax()` function defines the range for the size of a grid track, specifying how much space a row or column can occupy.

Remember that you can set the track size with units like `px` (pixels), `rem`, or even `em`, and with fractional units (`fr`).

The `minmax()` function takes things a bit further by allowing you to set a minimum size and a maximum size for the grid track.

Here's the syntax of the `minmax()` function:

```css
minmax(min, max)
```

`min` is the minimum size of the grid track, which can be set using pixels, percentage, or `auto`. And `max` is the maximum size of the grid track which you can set with the same units.

The two values work together this way:

- The `min` value ensures the grid track will never shrink below a set size.

- The `max` value limits how large the grid track can grow.

The grid track size adjusts dynamically between the `min` and `max` values based on content and container size.

Let's look at a practical example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div>
    <h2>Item 1</h2>
  </div>
  <div>
    <h2>Item 2</h2>
  </div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-columns: minmax(150px, 300px) 1fr;
  gap: 20px;
}

.grid-container > div {
  background: crimson;
  padding: 20px;
  text-align: center;
}
```

:::

What's happening here? 

The first column, `minmax(150px, 300px)`, will always be at least `150px` and at most `300px`, depending on the available space.

On the other hand, the second column, `1fr`, will take up any available remaining space in the grid container since there are no additional columns to share the space with.

The advantage of the `minmax()` function over fixed sizes and even `fr` units is that it is more flexible, making it ideal for adaptability and responsiveness.

# --questions--

## --text--

Which function can you use to define the range for the size of a grid track?

## --answers--

`clamp()`

### --feedback--

This function is for clamping a value between a minimum and maximum but doesn't define grid track ranges.

---

`minmax()`

---

`max-width()`

### --feedback--

This property sets the maximum width of an element, not a grid track range.

---

`calc()`

### --feedback--

This function performs calculations but doesn't define grid track ranges.

## --video-solution--

2

## --text--

Which of the following best describes how the grid track size behaves when using the `minmax()` function?

## --answers--

The grid track size is fixed between the minimum and maximum values.

### --feedback--

The grid track size adjusts dynamically, not fixed, between the given min and max values.

---

The grid track size adjusts dynamically between the min and max values based on content and container size.

---

The grid track size will always be set to the maximum value, regardless of content.

### --feedback--

The grid track size adjusts based on both the min and max values, not just the maximum.

---

The grid track size only responds to content, not container size.

### --feedback--

The size adjusts dynamically based on both content and container size.

## --video-solution--

2

## --text--

What does the min and max value in the `minmax()` function control?

## --answers--

The min value allows shrinking, and the max value sets a fixed size.

### --feedback--

The min value prevents shrinking below the specified size, and the max value limits growth.

---

The min value ensures the grid track won't shrink below a set size, and the max value limits how large it can grow.

---

The min value limits growth, and the max value determines the smallest size.

### --feedback--

The max value limits growth, and the min value ensures a minimum size, not the other way around.

---

Both values set fixed sizes for the grid track.

### --feedback--

The min and max values define a range, not fixed sizes.

## --video-solution--

2
