---
id: 673226afcd33991dd751937a
title: How Do the grid-column and grid-row Properties Work?
challengeType: 19
dashedName: how-do-the-grid-column-and-grid-row-properties-work
---

# --interactive--

The `grid-column` and `grid-row` properties let you specify the horizontal and vertical placement of grid items within a grid layout.

In other words, they both allow you to control where a grid item begins and ends by referencing grid lines. These grid lines are the boundaries that separate rows and columns you have already defined using the `grid-template-rows` and `grid-template-columns` properties.

Let's take a look at the syntaxes of both `grid-row` and `grid-column`, and also a practical example.

Here's the syntax of the `grid-row` property:

```css
grid-row: <start-line> / <end-line>;
```

And of `grid-column`:

```css
grid-column: <start-line> / <end-line>;
```

`<start-line>` is the grid line where the item starts and `<end-line>` is the grid line where the item ends. Both are 1-indexed, that is, you start counting them from 1, not 0.

Remember, grid lines for rows are generated based on the number of rows specified in the `grid-template-rows` property. The same applies to columns with the `grid-template-columns` property.

For the practical example, let's start with the lines generated by the browser when you use both the `grid-template-rows` and the `grid-template-columns` properties.

Here is an example grid with 4 columns and 3 rows:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid">
  <div class="item1">1</div>
  <div class="item2">2</div>
  <div class="item3">3</div>
  <div class="item4">4</div>
  <div class="item5">5</div>
  <div class="item6">6</div>
  <div class="item7">7</div>
  <div class="item8">8</div>
  <div class="item9">9</div>
  <div class="item10">10</div>
  <div class="item11">11</div>
  <div class="item12">12</div>
</div>
```

```css
.grid {
  display: grid;
  grid-template-columns: repeat(4, 1fr); /* 4 equal columns */
  grid-template-rows: repeat(3, 100px); /* 3 equal rows */
  gap: 10px;
}

.grid > div {
  display: grid;
  place-items: center;
  background: crimson;
  color: white;
  font-size: 4rem;
}
```

:::

Inspecting the grid container (the class `grid`) shows that each row and column is bounded by two lines – a start line at the beginning of the row or column, and an end line at the end of the row or column.

You can target these lines to start using the `grid-row` and `grid-column` properties to determine where you should place an item.

Here's how you can make the first grid item occupy the first two columns:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid">
  <div class="item1">1</div>
  <div class="item2">2</div>
  <div class="item3">3</div>
  <div class="item4">4</div>
  <div class="item5">5</div>
  <div class="item6">6</div>
  <div class="item7">7</div>
  <div class="item8">8</div>
  <div class="item9">9</div>
  <div class="item10">10</div>
  <div class="item11">11</div>
  <div class="item12">12</div>
</div>
```

```css
.grid {
  display: grid;
  grid-template-columns: repeat(4, 1fr); /* 4 equal columns */
  grid-template-rows: repeat(3, 100px); /* 3 equal rows */
  gap: 10px;
}

.grid > div {
  display: grid;
  place-items: center;
  background: crimson;
  color: white;
  font-size: 4rem;
}

.item1 {
  grid-column: 1 / 3;
}
```

:::

With this, you're saying the first grid item should start at column 1 and end just before column 3.

The first item will now occupy two columns, and the fourth item gets pushed to the second row. Cool!

If you also want the first item to occupy two rows, you can specify a `grid-row` of `1 / 3`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid">
  <div class="item1">1</div>
  <div class="item2">2</div>
  <div class="item3">3</div>
  <div class="item4">4</div>
  <div class="item5">5</div>
  <div class="item6">6</div>
  <div class="item7">7</div>
  <div class="item8">8</div>
  <div class="item9">9</div>
  <div class="item10">10</div>
  <div class="item11">11</div>
  <div class="item12">12</div>
</div>
```

```css
.grid {
  display: grid;
  grid-template-columns: repeat(4, 1fr); /* 4 equal columns */
  grid-template-rows: repeat(3, 100px); /* 3 equal rows */
  gap: 10px;
}

.grid > div {
  display: grid;
  place-items: center;
  background: crimson;
  color: white;
  font-size: 4rem;
}

.item1 {
  grid-column: 1 / 3;
  grid-row: 1 / 3;
}
```

:::

You can also use the `span` keyword to tell the grid item which row and column to span across. For example, `1 / 3` is the same as `1 / span 2`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid">
  <div class="item1">1</div>
  <div class="item2">2</div>
  <div class="item3">3</div>
  <div class="item4">4</div>
  <div class="item5">5</div>
  <div class="item6">6</div>
  <div class="item7">7</div>
  <div class="item8">8</div>
  <div class="item9">9</div>
  <div class="item10">10</div>
  <div class="item11">11</div>
  <div class="item12">12</div>
</div>
```

```css
.grid {
  display: grid;
  grid-template-columns: repeat(4, 1fr); /* 4 equal columns */
  grid-template-rows: repeat(3, 100px); /* 3 equal rows */
  gap: 10px;
}

.grid > div {
  display: grid;
  place-items: center;
  background: crimson;
  color: white;
  font-size: 4rem;
}

.item1 {
  grid-column: 1 / span 2;
  grid-row: 1 / span 2;
}
```

:::

You can continue to apply this technique to any item on the grid and place them wherever you want. 

Continuing the process, here's how we made a masonry layout with the items.

This is a new example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid">
  <div class="item1">1</div>
  <div class="item2">2</div>
  <div class="item3">3</div>
  <div class="item4">4</div>
  <div class="item5">5</div>
  <div class="item6">6</div>
  <div class="item7">7</div>
</div>
```

```css
.grid {
  display: grid;
  grid-template-columns: repeat(4, 1fr); /* 4 equal columns */
  grid-template-rows: repeat(4, 100px); /* 4 equal rows */
  gap: 10px;
}

.grid > div {
  display: grid;
  place-items: center;
  background: crimson;
  color: white;
  font-size: 4rem;
}

.item1 {
  grid-column: 1 / span 2;
}

.item4 {
  grid-column: 1 / span 3;
}

.item6 {
  grid-column: 1 / span 2;
}

.item7 {
  grid-column: 3 / span 2;
}
```

:::

# --questions--

## --text--

What do the `grid-column` and `grid-row` properties specify in a grid layout?

## --answers--

The size of the grid container.

### --feedback--

Think about the properties that determine where grid items are placed within the rows and columns.

---

The alignment of the entire grid.

### --feedback--

Think about the properties that determine where grid items are placed within the rows and columns.

---

The horizontal and vertical placement of grid items.

---

The size of grid tracks.

### --feedback--

Think about the properties that determine where grid items are placed within the rows and columns.

## --video-solution--

3

## --text--

What determines the number of grid lines generated for rows and columns in a grid layout?

## --answers--

The `grid-gap` property.

### --feedback--

Look out for the properties that explicitly define the rows and columns.

---

The `grid-template-rows` and `grid-template-columns` properties.

---

The `grid-auto-rows` and `grid-auto-columns` properties.

### --feedback--

Look out for the properties that explicitly define the rows and columns.

---

The `grid-area` property.

### --feedback--

Look out for the properties that explicitly define the rows and columns.

## --video-solution--

2

## --text--

How can you specify the way grid items span across rows or columns in a grid layout?

## --answers--

By using the `grid-template` property.

### --feedback--

Think about what allows you to control how many rows or columns the item will cover, often using a range or keyword.

---

By specifying `auto` in `grid-column` or `grid-row`.

### --feedback--

Think about what allows you to control how many rows or columns the item will cover, often using a range or keyword.

---

By using the `span` keyword or range like `1 / 3`.

---

By defining the `grid-gap` size.

### --feedback--

Think about what allows you to control how many rows or columns the item will cover, often using a range or keyword.

## --video-solution--

3
