---
id: 673226b97d4a731e0577ae93
title: How Can You Position Items on the Grid Using the grid-template-areas Property?
challengeType: 19
dashedName: how-can-you-position-items-on-the-grid-using-the-grid-template-areas-property
---

# --interactive--

The `grid-template-areas` property lets you design a visual grid layout by using named labels.

You then assign the labels to specific grid items using the grid-area property. So, in other words, those named labels are also called "grid area names".

Here's the basic syntax of the `grid-template-areas` property:

```css
grid-template-areas:
 'header header header'
 'left-sidebar main right-sidebar'
 'footer footer footer';
```

Here are the points to take away from the basic syntax:

- Values like `header` and `main` are the names of the grid areas.

- Each space-separated value within a string corresponds to a column.

- Each string represents a row in the grid.

So, in the syntax, we have a 3 by 3 grid container.

After defining the template, you then have to use the `grid-area` property and the named labels (or areas) as values to tell CSS that a specific element belongs in that area of the grid.

The `grid-area` property connects the grid item to the named region you define in the `grid-template-areas`.

A popular way to demonstrate the capabilities of the `grid-template-areas` property is by creating the classic Holy Grail layout.

If you don't know what it is, the Holy Grail layout is a web design pattern with a header, footer, two sidebars, and a main content area. It ensures the main content takes priority, while sidebars and other sections adjust responsively within the layout.

Many solutions exist to implement the holy grail layout, but using `grid-template-areas` and the `grid-area` property is the most straightforward way to create it.

Here's an example for the holy grail layout:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="grid-container">
  <div class="header">
    <h2>Header</h2>
  </div>
  <div class="sidebar-left">
    <h2>Left Sidebar</h2>
  </div>
  <div class="main"><h2>Main Content</h2></div>
  <div class="sidebar-right">
    <h2>Right Sidebar</h2>
  </div>
  <div class="footer">
    <h2>Footer</h2>
  </div>
</div>
```

```css
.grid-container {
  display: grid;
  grid-template-areas:
    'header header header'
    'sidebar-left main sidebar-right'
    'footer footer footer';
  grid-gap: 10px;
  background-color: #2196F3;
  padding: 10px;
}

.header {
  grid-area: header;
  background-color: rgba(255, 255, 255, 0.8);
  padding: 20px;
  text-align: center;
}

.sidebar-left {
  grid-area: sidebar-left;
  background-color: rgba(255, 255, 255, 0.8);
  padding: 20px;
  text-align: center;
}

.main {
  grid-area: main;
  background-color: rgba(255, 255, 255, 0.8);
  padding: 20px;
  text-align: center;
}

.sidebar-right {
  grid-area: sidebar-right;
  background-color: rgba(255, 255, 255, 0.8);
  padding: 20px;
  text-align: center;
}

.footer {
  grid-area: footer;
  background-color: rgba(255, 255, 255, 0.8);
  padding: 20px;
  text-align: center;
}
```

:::

Please note that both the `grid-template-areas` and `grid-area` properties can be used independently of each other.

The `grid-template-areas` property is specifically used to define a visual layout by mapping out named grid areas within the grid container.

On the other hand, the `grid-area` property is used to position individual grid items, either by specifying their row and column positions or by referencing the named areas defined with the `grid-template-areas` property.

# --questions--

## --text--

How do you design a grid layout with the `grid-template-areas` property?

## --answers--

With comma separated values like `1 / 4` to represent the different rows and columns of the layout.

### --feedback--

Recall that this property uses separate strings, each with separate values, to represent the different rows and columns of the layout, respectively.

---

With comma separated values like `header` and `footer`.

### --feedback--

Recall that this property uses separate strings, each with separate values, to represent the different rows and columns of the layout, respectively.

---

With strings of space-separated values to represent the different rows and columns of the layout.

---

With space-separated values like `2fr 1fr 1fr`.

### --feedback--

Recall that this property uses separate strings, each with separate values, to represent the different rows and columns of the layout, respectively.

## --video-solution--

3

## --text--

Which property do you use the `grid-template-areas` property in combination with?

## --answers--

`grid-column`

### --feedback--

It's the property that assigns grid items to named labels.

---

`grid-row`

### --feedback--

It's the property that assigns grid items to named labels.

---

`grid-gap`

### --feedback--

It's the property that assigns grid items to named labels.

---

`grid-area`

## --video-solution--

4

## --text--

What is the specific use case of the `grid-area` property?

## --answers--

To specify an area of the grid to exclude.

### --feedback--

This property places individual grid items within specific positions.

---

To specify the size of grid items.

### --feedback--

This property places individual grid items within specific positions.

---

To place individual grid items by specifying row and column positions.

---

To create a visual representation of the grid.

### --feedback--

This property places individual grid items within specific positions.

## --video-solution--

3
