---
id: 672bccdb8f1823d8c60f914c
title: What Is a CSS Reset, and What Are Some Common Examples?
challengeType: 19
dashedName: what-is-a-css-reset
---

# --interactive--

A CSS reset is a stylesheet that removes all or some of the default formatting that web browsers apply to HTML elements. For example, you might have noticed that certain elements, like paragraphs and headings, already have margins by default even if you don't define them explicitly in your custom stylesheets. 

You will also see this with various properties in a wide range of HTML elements. Different browsers may also apply different default styles to HTML elements. The default styles in Google Chrome may not be exactly the same as in Mozilla Firefox or Microsoft Edge. This can result in inconsistent styles across browsers which you should avoid as much as possible.

To handle this, a CSS reset removes the default styles. By removing all or some of the default styles, you can get a consistent baseline for your design and minimize the potential inconsistencies across browsers and devices. Removing default styles can also make the styling process easier because you will only see the styles that you have applied explicitly in your custom stylesheets. There are two main approaches to CSS resets: you can either define custom CSS resets or use third-party CSS resets.

Custom CSS resets are stylesheets that you create from scratch to fit the need of your project. This way you can control the specific styles that will be reset with a lot of room for flexibility. However, you also need to invest time to develop and maintain the stylesheets. Here's an example of a very common CSS rule for resetting the margin and padding of all HTML elements:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<h1>Example Heading</h1>
<p>This is a paragraph.</p>
```

```css
* {
  margin: 0;
  padding: 0;
}
```

:::

It's usually written at the top of the CSS stylesheet. The asterisk selector is a wildcard selector that matches all HTML elements, so they will have a default margin of zero and a default padding of zero on all four sides. This will give you a starting point and then you can customize them in more specific CSS selectors further down in the stylesheet.

You can use this approach to select any HTML element and reset its default styles. Just create a custom stylesheet and use the appropriate CSS selectors to match the elements and set the styles. 

But this can be a time intensive process. If you want to save time, you can also use a third-party CSS reset. These stylesheets are already pre-built so you can just download them and add them to your project directly. A great example of a third-party CSS reset is `Normalize.css`. This stylesheet normalizes styles for a wide range of HTML elements while still keeping some useful default styles especially those that are important for accessibility. It also corrects common bugs and style inconsistencies.

Another option is `sanitize.css`. This is a CSS library that you can use to ensure that default styles will be consistent across all major modern browsers. This library is developed alongside `Normalize.css`, so they evolve together. It also has individual stylesheets that you can download for specific purposes like normalizing forms and typography.

There are many options available but you should choose the ones that best fit the needs of your project. You can also combine both approaches using third-party CSS resets with custom resets.

When working with CSS resets, it's also important to take accessibility into account. Your web application should be accessible to everyone. So, you shouldn't reset styles that might be helpful for screen readers or other assistive technologies. You should also consider the impact that these additional stylesheets may have on your applications performance, because they have to be downloaded before the custom styles are applied. 

By removing the default styles, CSS resets give you a blank starting point to implement your design. This results in a more uniform and consistent user experience across browsers and across devices.

# --questions--

## --text--

What is the primary purpose of a CSS reset?

## --answers--

To add default styles to HTML elements.

### --feedback--

Think about how a CSS reset affects the starting point of your styles.

---

To establish a consistent baseline for styling, reducing browser-specific variations.

---

To create responsive designs.

### --feedback--

Think about how a CSS reset affects the starting point of your styles.

---

To enhance website performance.

### --feedback--

Think about how a CSS reset affects the starting point of your styles.

## --video-solution--

2

## --text--

Which of the following is a popular third-party browser reset?

## --answers--

Normalize.css

---

Reset.css

### --feedback--

Think about the third-party CSS resets that you learned.

---

Skeleton

### --feedback--

Think about the third-party CSS resets that you learned.

---

Foundation

### --feedback--

Think about the third-party CSS resets that you learned.

## --video-solution--

1

## --text--

What is the main advantage of using a custom CSS reset over a third-party CSS reset?

## --answers--

More flexibility and control over the styles.

---

Improved browser compatibility.

### --feedback--

Think about the level of customization that custom CSS resets.

---

Simpler implementation.

### --feedback--

Think about the level of customization that custom CSS resets.

---

Faster loading times.

### --feedback--

Think about the level of customization that custom CSS resets.

## --video-solution--

1
