---
id: 672bccebe1fc82d911c3f078
title: What Is the CSS Filter Property, and What Are Common Examples?
challengeType: 19
dashedName: what-is-the-css-filter-property
---

# --interactive--

The CSS `filter` property is a powerful tool that allows you to apply graphical effects to elements on a web page. It's particularly useful for adjusting the visual presentation of images, backgrounds, and even text without modifying the original asset.

The `filter` property can be used to create various effects, such as blurring, color shifting, and contrast adjustments. Let's discuss how the filter property works and explore some common examples. The basic syntax for a `filter` property is straightforward:

```css
selector {
  filter: function(amount);
}
```

Here, `function` represents the specific filter effect you want to apply, and `amount` is typically a value that determines the intensity of the effect. Now let's look at some common filter functions and their uses.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
```

```css
img {
  filter: blur(2px);
}
```

:::

The `blur` function applies a Gaussian blur to the element, the amount is specified in pixels and represents the radius of the blur. This CSS rule will apply a 2-pixel blur to all images on the page. The `blur` effect can be useful for creating depth in your design or for obscuring parts of an image. 

The `brightness` function adjusts the brightness of the element. A value of `0%` will make the element completely black, while values over `100%` will increase the brightness. 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
```

```css
img {
  filter: brightness(150%);
}
```

:::

This CSS rule increases the brightness of the image element by `50%`. Brightness adjustments can be used to make images pop or create a washed-out effect.

The `grayscale` function converts the element to grayscale. The amount is defined as a percentage, where `100%` is completely grayscale and `0%` leaves the image unchanged.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
```

```css
img {
  filter: grayscale(100%);
}
```

:::

This rule will convert the image element to full grayscale. `grayscale` can be used to create a vintage look or de-emphasize certain elements on a page.

The `sepia` function applies a sepia tone to the element. Like grayscale, it uses a percentage value: 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
```

```css
img {
  filter: sepia(80%);
}
```

:::

This rule applies an `80%` sepia effect to the image element. The sepia effect is great for creating a vintage or old-timey look.

The `hue-rotate` function applies a hue rotation to the element. The value is defined in degrees, and represents a rotation around the color circle. 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
```

```css
img {
  filter: hue-rotate(90deg);
}
```

:::

This rule rotates the hue of the image element by `90` degrees. Hue rotation can be used to create psychedelic effects or to adjust the overall color scheme of an image.

One of the most powerful aspects of the `filter` property is the ability to combine multiple effects. You can apply several filters to the same element by separating them with spaces: 

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/relaxing-cat.jpg" alt="A cute orange cat lying on its back.">
```

```css
img {  
  filter: contrast(150%) brightness(110%) sepia(30%);  
}
```

:::

This rule applies increased contrast, slightly increased brightness, and a subtle sepia effect to the image element. 

By combining filters, you can create complex and unique visual effects tailored to your design needs. The CSS filter property is a versatile tool that allows for creative visual manipulation of web elements. 

While we have covered some of the most common filter functions, there are others available, such as `contrast`, `invert`, and `saturate`. As with any powerful feature, it's important to be careful with how you use the filters to enhance your design without overwhelming your users or compromising accessibility.

# --questions--

## --text--

Which of the following CSS rules would make an image completely grayscale?

## --answers--

`filter: grayscale(100%);`

---

`filter: gray(100%);`

### --feedback--

Remember that grayscale uses a percentage value, and there are multiple ways to represent 100%.

---

`filter: gray(100);`

### --feedback--

Remember that grayscale uses a percentage value, and there are multiple ways to represent 100%.

---

`filter: black-and-white(true);`

### --feedback--

Remember that grayscale uses a percentage value, and there are multiple ways to represent 100%.

## --video-solution--

1

## --text--

What would be the effect of applying `filter: brightness(0%);` to an element?

## --answers--

It would make the element completely white.

### --feedback--

Think about what `0%` brightness means in terms of light.

---

It would make the element completely black.

---

It would have no effect on the element.

### --feedback--

Think about what `0%` brightness means in terms of light.

---

It would invert the colors of the element.

### --feedback--

Think about what `0%` brightness means in terms of light.

## --video-solution--

2

## --text--

How would you combine a blur effect of 5 pixels with a sepia effect of 50%?

## --answers--

`filter: blur(5px) + sepia(50%);`

### --feedback--

Remember how multiple filter functions are combined in a single filter property.

---

`filter: blur(5px), sepia(50%);`

### --feedback--

Remember how multiple filter functions are combined in a single filter property.

---

`filter: blur(5px) sepia(50%);`

---

`filter: blur(5px) && sepia(50%);`

### --feedback--

Remember how multiple filter functions are combined in a single filter property.

## --video-solution--

3
