---
id: 673500abfe36cd015b67b1b7
title: How Does Conditional Rendering Work in React Components?
challengeType: 19
dashedName: how-does-conditional-rendering-work-in-react-components
---

# --description--

Conditional rendering in React allows you to create dynamic user interfaces. It is used to show different content based on certain conditions or states within your application.

The most common approaches of using conditional rendering includes using `if` statements, the ternary (`?:`) operator, and logical AND (`&&`) operator.

The simplest form of conditional rendering uses an `if` statement. Here's an example:

```jsx
function Greeting({ isLoggedIn }) {
  if (isLoggedIn) {
    return <h1>Welcome back!</h1>;
  }
  return <h1>Please sign in</h1>;
}
```

In this example, the `Greeting` component checks the `isLoggedIn` prop. If it's `true`, it returns a welcome message, otherwise, it prompts the user to sign in.

Here is an example using the `Greeting` component inside of the parent `App` component:

```jsx
function App() {
  return (
    <div className="App">
      <Greeting isLoggedIn={false} />
    </div>
  );
}
```

For simpler conditions, the ternary operator (`?:`) is often used directly within JSX. It allows for inline conditional rendering, which can make your code more concise:

```jsx
function Greeting({ isLoggedIn }) {
  return <h1>{isLoggedIn ? "Welcome back!" : "Please sign in."}</h1>;
}
```

This code achieves the same result as the previous example but in a more compact form. The ternary operator checks `isLoggedIn` and renders the appropriate message.

Another common pattern for conditional rendering is using the logical AND (`&&`) operator. This is particularly useful when you want to render something, or nothing, based on a condition:

```jsx
function Notification({ message }) {
  return (
    <div>
      {message && <p>{message}</p>}
    </div>
  );
}
```

In this example, the paragraph element with the message is only rendered if the `message` prop is truthy. If `message` is falsy - meaning it is an empty string, `null`, or `undefined`, nothing is rendered to the screen.

By mastering these techniques of conditional rendering, you can build more interactive and user-friendly applications that adapt to changing data and user interactions.

# --questions--

## --text--

Which of the following is NOT a common method for conditional rendering in React?

## --answers--

Using `if` statements.

### --feedback--

Think about the methods discussed in the lesson for handling conditional rendering in React.

---

Using the ternary operator.

### --feedback--

Think about the methods discussed in the lesson for handling conditional rendering in React.

---

Using the logical AND (`&&`) operator

### --feedback--

Think about the methods discussed in the lesson for handling conditional rendering in React.

---

Using the `switch` statement.

## --video-solution--

4

## --text--

What will be rendered by the following code if `message` is an empty string?

```jsx
function Alert({ message }) {
  return (
    <div>
      {message && <p>{message}</p>}
    </div>
  );
}
```

## --answers--

`<div><p></p></div>`

### --feedback--

Consider how the logical AND (`&&`) operator works with falsy values in JSX.

---

`<div></div>`

---

`<div>false</div>`

### --feedback--

Consider how the logical AND (`&&`) operator works with falsy values in JSX.

---

This will throw an error.

### --feedback--

Consider how the logical AND (`&&`) operator works with falsy values in JSX.

## --video-solution--

2

## --text--

In the following code, what type of conditional rendering is being used?

```jsx
function Greeting({ name }) {
  return <h1>{name ? `Hello, ${name}!` : 'Hello, Guest!'}</h1>;
}
```

## --answers--

`if` statement.

### --feedback--

Look at the syntax used within the JSX to conditionally render different content.

---

`switch` statement.

### --feedback--

Look at the syntax used within the JSX to conditionally render different content.

---

Ternary operator.

---

Logical AND (`&&`) operator.

### --feedback--

Look at the syntax used within the JSX to conditionally render different content.

## --video-solution--

3
