---
id: 6732518a8627876f4fcd18a4
title: How Does the typeof Operator Work, and What Is the typeof null Bug in JavaScript?
challengeType: 19
dashedName: how-does-the-typeof-operator-work-and-what-is-the-typeof-null-bug-in-javascript
---

# --interactive--

The `typeof` operator in JavaScript is a simple yet powerful tool that lets you see the data type of a variable or value. It always returns a string indicating the type.

Let's take a look at a few examples:

:::interactive_editor

```js
let num = 42;
console.log(typeof num); // "number"
```

:::

In this first example, we have created a variable called `num` and assigned it the number `42`. When you use the `typeof` operator on the variable named `num`, it will return the string `number`.

Here is another example of using the `typeof` operator on variable called `isUserLoggedIn`:

:::interactive_editor

```js
let isUserLoggedIn = true;
console.log(typeof isUserLoggedIn); // "boolean"
```

:::

When you use the `typeof` operator on the `isUserLoggedIn` variable, it will return a string `boolean` because the boolean `true` was assigned to the variable.

Using the `typeof` operator can be especially useful when you're debugging or trying to understand what kind of data you're working with in your code.

However, there's a well-known quirk in JavaScript when it comes to `null`.

Let's take a look at an example:

:::interactive_editor

```js
let exampleVariable = null;
console.log(typeof exampleVariable); // "object"
```

:::

In this example, we have a variable called `exampleVariable` and have assigned it the value of `null`. But when we use the `typeof` operator, it returns the string `object`.

This is widely considered a bug in JavaScript, dating back to its early days. The reason for this behavior is rooted in the way JavaScript was originally designed.

When the language was first implemented, values like `null` were represented as a special type of object, leading to this unexpected result.

Unfortunately, this has become a part of the language, and while it's confusing, it's something you'll need to be aware of.

# --questions--

## --text--

What does the `typeof` operator return when used on a string in JavaScript?

## --answers--

`"string"`

---

`"text"`

### --feedback--

Think about the output when you check the type of `"Hello"`.

---

`"character"`

### --feedback--

Think about the output when you check the type of `"Hello"`.

---

`"object"`

### --feedback--

Think about the output when you check the type of `"Hello"`.

## --video-solution--

1

## --text--

Why is `typeof null` considered a bug in JavaScript?

## --answers--

It returns `"null"` instead of `"undefined"`.

### --feedback--

Recall the unexpected behavior when checking the type of `null`.

---

It returns `"object"` instead of `"null"`.

---

It doesn't work on `null`.

### --feedback--

Recall the unexpected behavior when checking the type of `null`.

---

It returns an error.

### --feedback--

Recall the unexpected behavior when checking the type of `null`.

## --video-solution--

2

## --text--

What does the `typeof` operator return when used on a number in JavaScript?

## --answers--

`"number"`

---

`"integer"`

### --feedback--

Consider the type `typeof` returns for both integers and floats.

---

`"numeric"`

### --feedback--

Consider the type `typeof` returns for both integers and floats.

---

`"float"`

### --feedback--

Consider the type `typeof` returns for both integers and floats.

## --video-solution--

1
