---
id: 672ac37104dc2530a769e6a4
title: What Are Best Practices for Naming Files for Web Applications?
challengeType: 19
dashedName: what-are-best-practices-for-naming-files-for-web-applications
---

# --description--

As you start to build out your own web applications, you will need to be mindful of what you name your files.

You will want to name your files in a way that is easy to understand and maintain.

Let's take a look at some examples of good and bad file names for HTML files. Note that the `.html` extension in these examples tells us that this is an HTML file.

Here is an example of a bad file name: 

```md
index1234.html
```

By the name alone, it is not clear what the file is about. This file could be for a products page, blog page, or any other type of page but we don't know that from the file name.

Here is an example of a better file name for an HTML file:

```md
about-us.html
```

By using a more descriptive name like `about-us.html`, it is clear what the file is about.

You will also notice in this file name that there are no spaces. Instead, you use a hyphen, `-`, to separate the words. 

Sometimes you might see a file name called `index.html`. This is a special file name that is used to represent the main page of a website. When you visit a website, the `index.html` file is the first file that is loaded.

Another important consideration when naming files is the use of special characters.

Using a mixture of special characters, numbers, and letters can make it difficult to understand what the file is about.

Here is an example of a bad file name:

```md
file-1!@.html
```

This name looks unnecessarily complicated and does not give us any information about what the file is about.

So it is best to stick with only using letters and dashes in your file names.

As you start to learn more languages, you will see that there are common conventions for naming files in those languages as well. 

In these situations, it is always best to consult with official documentation or other resources to understand the best practices for naming files in that language.

Also you will be in situations where you are working on a team and you will need to follow the conventions that the team has established for naming files. 

Always consult with the team's style guide to make sure your file names are consistent with the rest of the team.

# --questions--

## --text--

Which of the following is a bad example for naming an HTML file?

## --answers--

`index.html`

### --feedback--

Think about the file name that looks complicated.

---

`about-us.html`

### --feedback--

Think about the file name that looks complicated.

---

`file-1!@.html`

---

`products.html`

### --feedback--

Think about the file name that looks complicated.

## --video-solution--

3

## --text--

What does the `index.html` file represent?

## --answers--

The main page of a website.

---

A database file used to store user information.

### --feedback--

Think about the main content of a website.

---

A configuration file for server settings.

### --feedback--

Think about the main content of a website.

---

A script file for running server-side code.

### --feedback--

Think about the main content of a website.

## --video-solution--

1

## --text--

Why are special characters not recommended for file names?

## --answers--

They make files incompatible with all operating systems.

### --feedback--

Think about the purpose of file names.

---

They make it difficult to understand what the file is about.

---

They lead to frequent software crashes.

### --feedback--

Think about the purpose of file names.

---

They make it impossible to transfer files between computers.

### --feedback--

Think about the purpose of file names.

## --video-solution--

2
