---
id: 672ac403a9ba7732b31c6480
title: What Are Some Common File Types You Will Work With in Web Applications?
challengeType: 19
dashedName: what-are-some-common-file-types-you-will-work-with-in-web-applications
---

# --description--

Files are classified based on their content and structure. The file type determines how a file is opened and processed by computer programs.

We identify file types based on their extensions. A file extension is a three or four letter suffix at the end of the file name. The three main file types that you will find in web applications are HTML, CSS, and JavaScript.

HTML files contain the structure and content of the web application. They have a `.html` file extension.

CSS files define the styles. They have a `.css` file extension.

And JavaScript files add more advanced functionality and interactivity. They have a `.js` file extension.

As you develop web applications, you will also need to include images. These are some of the most widely used image file types.

JPEG, which stands for "Joint Photographic Experts Group," is known for its efficient compression. It's great for photographs and images. However, the compression is lossy, which means that some image quality is lost to reduce the file size.

PNG, which stands for "Portable Network Graphics," preserves image quality, even after compression. This results in larger files. PNG supports transparency and it's great for images with sharp edges, like logos and icons.

The GIF image format supports both animation and transparency but has a limited color palette. GIF stands for "Graphics Interchange Format."

And finally, we have SVG, which stands for "Scalable Vector Graphics." It's a vector image format. These images can be scaled as much as needed without losing quality.

Great. Now that you know about image formats, let's see some video and audio formats.

MP3 is an audio format known for its efficient compression. It's a lossy format, so some audio data is lost during the compression to make these files smaller.

MP4 is one of the most common video formats. It offers good compression and supports multiple audio and video codecs, subtitles, and metadata.

MOV, the QuickTime multimedia file format developed by Apple, is primarily associated with QuickTime Player.

Other popular audio and video file types are WAV, a lossless audio format that keeps the original quality of the audio, and WebM, a high-quality open-source video format.

If you ever need to customize the fonts of your web application, you will also work with font formats. These are three of the most widely used ones.

TTF, which stands for "TrueType Font", is a font format compatible with different operating systems.

WOFF is a modern font format, specifically designed for web development purposes. It stands for "Web Open Font Format". These files are smaller because they have better compression. They can also store metadata, including licensing information.

And WOFF2 is the successor of WOFF with even more efficient compression and performance.

You can also create archive files if you need to group multiple folders and files. The most widely used archive format is ZIP. ZIP offers lossless compression, so no data is lost during the process. It's widely supported across operating systems and software applications.

And finally, let's talk about documentation. In web applications, you will usually find a file called `README` that contains information about the application, like how to use it, how to install it, its license, and how to contribute.

They are usually written in a file format called Markdown. With Markdown, you can create structured documents with headings, subheadings, links, images, lists, and more. Markdown files have a `.md` or `.markdown` extension.

Here you can find the `README` file of freeCodeCamp's GitHub repository: https://github.com/freeCodeCamp/freeCodeCamp/blob/main/README.md

You can create this detailed structure and format using Markdown.

You will definitely read and write many `README` files throughout your career. Learning about these common file types is essential for web development. 

From the core building blocks of HTML, CSS, and JavaScript to image, video, and audio formats, every file type has an important role in creating interactive web applications.

# --questions--

## --text--

Which file format is best suited for images with sharp edges and transparent backgrounds?

## --answers--

`JPEG`

### --feedback--

Think about the image format needed for logos and icons.

---

`PNG`

---

`GIF`

### --feedback--

Think about the image format needed for logos and icons.

---

`SVG`

### --feedback--

Think about the image format needed for logos and icons.

## --video-solution--

2

## --text--

Which one of these options is an audio format known for its lossless compression?

## --answers--

`MP3`

### --feedback--

Think about audio quality and file size. Lossless compression results in larger files.

---

`WAV`

---

`SVG`

### --feedback--

Think about audio quality and file size. Lossless compression results in larger files.

---

`MP4`

### --feedback--

Think about audio quality and file size. Lossless compression results in larger files.

## --video-solution--

2

## --text--

Which one of these options is a modern font format used for web development purposes?

## --answers--

`TTF`

### --feedback--

Think about which font format results in smaller file size and better compression.

---

`WOFF`

---

`GIF`

### --feedback--

Think about which font format results in smaller file size and better compression.

---

`ZIP`

### --feedback--

Think about which font format results in smaller file size and better compression.

## --video-solution--

2
