---
id: 673362a34edda41dedf87623
title: What Is the Map Method, and How Does It Work?
challengeType: 19
dashedName: what-is-the-map-method-and-how-does-it-work
---

# --interactive--

The `map` method is a powerful and widely used function in JavaScript that operates on arrays. It is designed to create a new array by applying a given function to each element of the original array.

This method does not modify the original array but instead returns a new array containing the results of the function applied to each element.

Here is an example of using the `map` method on an array of numbers:

:::interactive_editor

```js
const numbers = [1, 2, 3, 4, 5];
const doubled = numbers.map((num) => num * 2);
console.log(numbers); // [1, 2, 3, 4, 5]
console.log(doubled); // [2, 4, 6, 8, 10]
```

:::

To create a new array where each number is doubled, we are using the `map` method. The `map` method accepts a callback function where the function is called on every single element in the array.

In this case, each number in the array will be multiplied by `2`. The result will be a new array of the numbers `2,4,6,8,10`.

The callback function can accept up to three arguments.

The first argument is the current element being processed.

:::interactive_editor

```js
const numbers = [3, 4, 5, 6, 7].map((element) => {
  console.log("Element:", element);
  return element * 2;
});
```

:::

The second argument is the index of the current element being processed.

:::interactive_editor

```js
const numbers = [3, 4, 5, 6, 7].map((element, index) => {
  console.log("Element:", element);
  console.log("Index:", index);
  return element * 2;
});
```

:::

The third argument is the array where `map` is being called on.

:::interactive_editor

```js
const numbers = [3, 4, 5, 6, 7].map((element, index, array) => {
  console.log("Element:", element);
  console.log("Index:", index);
  console.log("Array:", array);
  return element * 2;
});
```

:::

Understanding and effectively using the `map` method can significantly improve your ability to work with arrays in JavaScript. In future lessons, we'll dive deeper into more advanced uses of `map` and explore how it can be a powerful tool for building dynamic and efficient programs.

# --questions--

## --text--

What does the `map` method return?

## --answers--

The original array, modified.

### --feedback--

Think about what we said regarding the result of the `map` operation.

---

A new array with the same number of elements as the original.

---

A single value.

### --feedback--

Think about what we said regarding the result of the `map` operation.

---

It doesn't return anything, it just modifies the original array.

### --feedback--

Think about what we said regarding the result of the `map` operation.

## --video-solution--

2

## --text--

How many arguments can the callback function in `map` receive?

## --answers--

One. The current element.

### --feedback--

Recall the full set of parameters we mentioned that the callback function can receive.

---

Two. The current element and its index.

### --feedback--

Recall the full set of parameters we mentioned that the callback function can receive.

---

Three. The current element, its index, and the original array.

---

It depends on how `map` is called.

### --feedback--

Recall the full set of parameters we mentioned that the callback function can receive.

## --video-solution--

3

## --text--

Which of the following is NOT a correct use of the `map` method?

## --answers--

Converting an array of strings to uppercase.

### --feedback--

Consider which operation doesn't fit with the idea of transforming each element into a new element.

---

Doubling each number in an array.

### --feedback--

Consider which operation doesn't fit with the idea of transforming each element into a new element.

---

Removing specific elements from an array.

---

Extracting a property from each object in an array.

### --feedback--

Consider which operation doesn't fit with the idea of transforming each element into a new element.

## --video-solution--

3
