---
id: 673362d7f94d551edb532d24
title: How Does the Sort Method Work?
challengeType: 19
dashedName: how-does-the-sort-method-work
---

# --interactive--

There are many different ways to sort your data in programming. In this lesson, we will focus on the built-in `sort` method in JavaScript.

The `sort` method is used to arrange the elements of an array and returns a reference to the sorted array. No copy is made because the elements are sorted in place.

Here is the basic syntax for the `sort` method:

```js
array.sort(compareFunction);
```

The `compareFunction` is an optional parameter that specifies a function that defines the sort order. We will take a look later on how to use a compare function when sorting numbers.

In this first example, we have an array of strings in random order.

```js
const fruits = ["Banana", "Orange", "Apple", "Mango"];
```

Our goal is to sort the array in alphabetical order. We can do this by calling the `sort` method on the `fruits` array.

:::interactive_editor

```js
const fruits = ["Banana", "Orange", "Apple", "Mango"];
fruits.sort();

console.log(fruits); // ["Apple", "Banana", "Mango", "Orange"]
```

:::

The result will be a sorted array of fruits in alphabetical order starting with the fruit `Apple`.

In this next example, we want to sort the following array of numbers:

```js
const numbers = [414, 200, 5, 10, 3];
```

If we try to use the `sort` method on this `numbers` array, we will get unexpected results.

:::interactive_editor

```js
const numbers = [414, 200, 5, 10, 3];
numbers.sort();

console.log(numbers); // [10, 200, 3, 414, 5]
```

:::

We expected to see the result `[3, 5, 10, 200, 414]`, but instead we got `[10, 200, 3, 414, 5]`.

This is because the `sort` method converts the elements to strings and then compares their sequences of UTF-16 code units values.

UTF-16 code units are the numeric values that represent the characters in the string. Examples of UTF-16 code units are the numbers `65`, `66`, and `67` which represent the characters `A`, `B`, and `C` respectively.

So, the number `200` appears before the number `3` in the array, because the string `200` comes before the string `3` when comparing their UTF-16 code units.

The solution to this problem is to provide a compare function to the `sort` method.

Here is an example of how to sort the `numbers` array using a compare function:

:::interactive_editor

```js
const numbers = [414, 200, 5, 10, 3];

numbers.sort((a, b) => a - b);

console.log(numbers); // [3, 5, 10, 200, 414]
```

:::

The parameters `a` and `b` are the two elements being compared. The compare function should return a negative value if `a` should come before `b`, a positive value if `a` should come after `b`, and zero if `a` and `b` are equal.

The first comparison is between the numbers `414` and `200`. The result of `414 - 200` is `214`, which is a positive value. This means that `414` should come after `200` in the sorted array.

The next comparison is between the numbers `200` and `5`. The result of `200 - 5` is `195`, which is a positive value. This means that `200` should come after `5` in the sorted array.

We repeat this process for all the elements in the array, and the result is a sorted array of numbers.

Even though there are many more ways to sort data in programming, the `sort` method in JavaScript can be useful and efficient in a lot of cases when you need to sort an array of elements.

# --questions--

## --text--

What does the `sort` method do in JavaScript?

## --answers--

It creates a copy of the array and sorts the copy.

### --feedback--

The method modifies the original array directly.

---

It sorts the elements of an array in place.

---

It only sorts numbers.

### --feedback--

The method modifies the original array directly.

---

It sorts elements in descending order by default.

### --feedback--

The method modifies the original array directly.

## --video-solution--

2

## --text--

Why do numbers not sort as expected when using the `sort` method without a compare function?

## --answers--

The `sort` method cannot sort numbers.

### --feedback--

Consider how JavaScript handles different data types when comparing.

---

The elements are compared as strings based on UTF-16 code units.

---

The `sort` method is case-sensitive.

### --feedback--

Consider how JavaScript handles different data types when comparing.

---

The method only works for strings.

### --feedback--

Consider how JavaScript handles different data types when comparing.

## --video-solution--

2

## --text--

What should a compare function return if `a` should come after `b`?

## --answers--

A negative value.

### --feedback--

Think about the ordering of elements.

---

Zero.

### --feedback--

Think about the ordering of elements.

---

A positive value.

---

`undefined`

### --feedback--

Think about the ordering of elements.

## --video-solution--

3
