---
id: 672a4fa7d335bc7cfb63a392
title: What Is an HTML Validator, and How Can It Help You Debug Your Code?
challengeType: 19
dashedName: what-is-an-html-validator
---

# --description--

HTML is a very forgiving language – elements still render even when you make mistakes, like forgetting to include a closing tag.

Let's say you have an `h2` element without a closing tag:

```html
<h1>Article Topic</h1>
<h2>Subheading 1 </h2>
<h2>Subheading 2 </h2>

<!-- This h2 does not have a closing tag -->
<h2>Subheading 3
```

The `h2` without a closing tag will still render fine. This happens because browsers use a parsing algorithm that handles common errors and tries to render HTML as closely as possible to the author's intention.

But this could backfire sometimes. Let's add a few paragraphs under the existing heading 2 tags in the code:

```html
<h1>Article Topic</h1>
<p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Maiores, nisi.</p>

<h2>Subheading 1 </h2>
<p>Lorem, ipsum dolor sit amet consectetur adipisicing elit. At, doloremque.</p>

<h2>Subheading 2 </h2>
<p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Unde, placeat.</p>

<!-- This h2 does not have a closing tag -->
<h2>Subheading 3
<p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Tempore, illum.</p>
```

As a result, the paragraph element under the `h2` without a closing `h2` tag renders as heading 2. This is why you need an HTML validator.

An HTML validator is a tool that checks the validity of your HTML code against the standard HTML specifications. It helps you identify errors and warnings in your HTML code, ensuring your web pages are correctly structured and compliant with web standards.

Using an HTML validator benefits not only you and your future code reviews, but also anybody else going through your code, such as your teammates and open-source contributors.

There are several HTML validators out there you can use. The most widely accepted one is the `w3.org` markup validation service.

When you visit the site [`validator.w3.org`](https://validator.w3.org/), you can click on the `Validate by Direct Input` button and paste in your HTML code.

When you click on the `Check` button, then a list of results will display with the errors that need to be fixed.

Another HTML validator that you can use is [`jsonformatter.org`](https://jsonformatter.org/).

You can copy and paste your HTML code inside the first editor, and when you click on the `Validate` button, it will show you any errors you have in your code.

# --questions--

## --text--

Why does the browser render tags correctly even when there's an error like forgetting to close a tag?

## --answers--

HTML does not care about closing a tag.

### --feedback--

Look out for the algorithm one of the tools use for figuring out what the author intends to do.

---

The browser's parsing algorithm figures out the errors and tries to render the tags as intended.

---

The code editor's diffing algorithm knows what the author wants to render.

### --feedback--

Look out for the algorithm one of the tools use for figuring out what the author intends to do.

---

HTML is smart enough to know what the author wants to show.

### --feedback--

Look out for the algorithm one of the tools use for figuring out what the author intends to do.

## --video-solution--

2

## --text--

What is an HTML validator?

## --answers--

A tool for writing HTML.

### --feedback--

Look out for the tool that figures out what is wrong with an HTML code.

---

A tool for arranging HTML code.

### --feedback--

Look out for the tool that figures out what is wrong with an HTML code.

---

A tool for making HTML code work across browsers.

### --feedback--

Look out for the tool that figures out what is wrong with an HTML code.

---

A tool that checks the validity of HTML.

## --video-solution--

4

## --text--

Which of these is an example of an HTML validator?

## --answers--

W3.org HTML validator

---

CSS Lint

### --feedback--

Look for the tool specifically designed to check the validity of HTML code.

---

JavaScript Debugger

### --feedback--

Look for the tool specifically designed to check the validity of HTML code.

---

Photoshop

### --feedback--

Look for the tool specifically designed to check the validity of HTML code.

## --video-solution--

1
