---
id: 6716830dbaf95da9564f2e3b
title: What Is the Difference Between Slashes, a Single Dot, and Double Dot in Path Syntax?
challengeType: 19
dashedName: what-is-the-difference-between-slashes-a-single-dot-and-double-dot-in-path-syntax
---

# --description--

You may have seen links like `/public/logo.png`, `./script.js`, or `../styles.css` before. But what do these special types of links mean? These are called file paths. There are three key syntaxes to know. First is the slash, which can be a backslash (`\`) or forward slash (`/`) depending on your operating system. The second is the single dot (`.`). And finally, we have the double dot (`..`).

The slash is known as the "path separator". It is used to indicate a break in the text between folder or file names. This is how your computer knows that `naomis-files/` points to a directory of that same name, while `naomis/files/` points to a `files` directory in the `naomis` directory.

A single dot points to the current directory, and two dots point to the parent directory. You will typically see a single dot used to ensure that the path is recognized as a relative path. Remember that you learned in a previous lesson about relative versus absolute paths before.

Double dots, however, are much more common to access files outside of the current working directory.

For example, given this file tree:

```sh
my-app/
├─ public/
│  ├─ favicon.ico
│  ├─ index.html
├─ src/
│  ├─ index.css
│  ├─ index.js
```

If your `public/index.html` file needed to load the `favicon.ico` file, you would use a relative path with a single dot to access the current directory: `./favicon.ico`. If your `public/index.html` file needed to load the `index.css` file, you would use a relative path with double dots to navigate to the parent `my-app` directory first, then to the `src` directory, and finally to your file: `../src/index.css`.

# --questions--

## --text--

Which option is an absolute path?

## --answers--

`/public/styles.css`

---

`./script.js`

### --feedback--

An absolute path starts with a slash.

---

`../src/nav.html`

### --feedback--

An absolute path starts with a slash.

---

`https://freecodecamp.org`

### --feedback--

An absolute path starts with a slash.

## --video-solution--

1

## --text--

Which option is a relative path to the current directory?

## --answers--

`/public/styles.css`

### --feedback--

A single dot points to the current directory.

---

`./script.js`

---

`../src/nav.html`

### --feedback--

A single dot points to the current directory.

---

`https://freecodecamp.org`

### --feedback--

A single dot points to the current directory.

## --video-solution--

2

## --text--

Which option is a relative path to the parent directory?

## --answers--

`/public/styles.css`

### --feedback--

A double dot points to the parent directory.

---

`./script.js`

### --feedback--

A double dot points to the parent directory.

---

`../src/nav.html`

---

`https://freecodecamp.org`

### --feedback--

A double dot points to the parent directory.

## --video-solution--

3
