---
id: 6839e4b003571c149bcda122
title: What Are the Enumerate and Zip Functions and How Do They Work?
challengeType: 19
dashedName: what-are-the-enumerate-and-zip-functions-and-how-do-they-work
---

# --description--

In previous lessons you learned how to work with the `for` loop, which is used to repeat a block of code a set number of times. Here is an example of using a `for` loop to print each language from the `languages` list to the console:

```py
languages = ['Spanish', 'English', 'Russian', 'Chinese']

for language in languages:
    print(language)
```

But what if you wanted to keep track of the index for each element? Well, one option is to create an `index` variable and increment it by `1` for each iteration of the loop, like this:

```py
languages = ['Spanish', 'English', 'Russian', 'Chinese']

index = 0

for language in languages:
    print(f'Index {index} and language {language}')
    index += 1
```

While that works, an easier way to do that is by using the `enumerate()` function. The `enumerate()` function keeps track of the index for an iterable and returns an enumerate object.

If we pass the `languages` list to the `enumerate()` function and convert its returned value into a list with the `list()` function, it looks like this:

```python
languages = ['Spanish', 'English', 'Russian', 'Chinese']

list(enumerate(languages))
# [(0, 'Spanish'), (1, 'English'), (2, 'Russian'), (3, 'Chinese')]
```

Each entry in the enumerate object (now a list) is a tuple containing a count, followed by a value from the iterable passed to the `enumerate()` function.

Now, let's refactor the example from earlier to use the `enumerate()` function:

```python
languages = ['Spanish', 'English', 'Russian', 'Chinese']

for index, language in enumerate(languages):
    print(f'Index {index} and language {language}')
```

We unpack the count and value for each tuple in the enumerate object into variables named `index` and `language`, respectively. Finally, both those variables are used in an f-string that's printed to the console in each iteration of the loop.

```md
Index 0 and language Spanish
Index 1 and language English
Index 2 and language Russian
Index 3 and language Chinese
```

This removes the need for manually creating and updating an `index` variable.

The `enumerate()` function also accepts an optional `start` argument that specifies the starting value for the count. If this argument is omitted, then the count will begin at `0`. Here is an example of using the optional `start` argument:

```python
languages = ['Spanish', 'English', 'Russian', 'Chinese']

for index, language in enumerate(languages, 1):
    print(f'Index {index} and language {language}')
```

And here is what the result will look like in the console:

```md
Index 1 and language Spanish
Index 2 and language English
Index 3 and language Russian
Index 4 and language Chinese
```

So far we've only been iterating over one list. But what if you need to iterate over multiple iterables in parallel? Well, you can use the `zip()` function for that, which combines lists into pairs of elements and returns an iterator of tuples.

If we pass a list of `developers` and `ids` to the `zip()` function and convert its returned value into a list with the `list()` function, here's what it looks like:

```python
developers = ['Naomi', 'Dario', 'Jessica', 'Tom']
ids = [1, 2, 3, 4]

list(zip(developers, ids))
# [('Naomi', 1), ('Dario', 2), ('Jessica', 3), ('Tom', 4)]
```

And here's an example of using the `zip()` function with a `for` loop to iterate over `developers` and `ids`:

```python
developers = ['Naomi', 'Dario', 'Jessica', 'Tom']
ids = [1, 2, 3, 4]

for name, id in zip(developers, ids):
    print(f'Name: {name}')
    print(f'ID: {id}')
```

In this example, `zip()` combines the two lists into pairs of elements and returns an iterator of tuples. The `for` loop then unpacks each tuple into `name` and `id`. Finally, for each print statement, we are printing each `name` and `id` from the `ids` and `developers` lists respectively. Here is what the result looks like in the console:

```md
Name: Naomi
ID: 1
Name: Dario
ID: 2
Name: Jessica
ID: 3
Name: Tom
ID: 4
```

The `enumerate()` and `zip()` functions are very powerful, and when combined with loops, can make your code much more concise.

# --questions--

## --text--

What does the `enumerate()` function do?

## --answers--

It is used to print the memory addresses for each element in a list. 

### --feedback--

Review the beginning of the lesson for the answer.

---

It is used to create tuples and sets from lists and return an `enumerate` object.

### --feedback--

Review the beginning of the lesson for the answer.

---

It is used to keep track of the index of an iterable and return an `enumerate` object.

---

It is used to speed up the performance for your Python applications.

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

3

## --text--

Which of the following optional arguments in the `enumerate()` function specifies the starting value for the count?

## --answers--

`set`

### --feedback--

Review the end of the lesson for the answer.

---

`position`

### --feedback--

Review the end of the lesson for the answer.

---

`start`

---

`count`

### --feedback--

Review the end of the lesson for the answer.

## --video-solution--

3

## --text--

What does the `zip()` function do?

## --answers--

It is used to iterate over multiple iterables in parallel.

---

It is used to create zip files.

### --feedback--

Review the end of the lesson for the answer.

---

It is used to break out of a nested loop.

### --feedback--

Review the end of the lesson for the answer.

---

It is used to create an iterable that saves memory starting from a list.

### --feedback--

Review the end of the lesson for the answer.

## --video-solution--

1
