---
id: 683d6a3fe8c1060ffb1f9b78
title: What Are Some Common Methods for Tuples?
challengeType: 19
dashedName: what-are-some-common-methods-for-tuples
---

# --description--

In the previous lesson, you learned how to work with the tuple data type. In this lesson, you'll learn about some common methods you'll use when working with tuples.

The first method we will cover is `count()`. This method is used to determine how many times an item appears in a tuple. Here is an example of checking how many times the string `Rust` appears in a tuple named `programming_languages`:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.count('Rust') # 2
```

Since `Rust` appears twice in the tuple, the `count()` method returns the number `2`. If the specified item in the `count()` function is not present at all in the tuple, then the return value is `0`:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.count('JavaScript') # 0
```

If no arguments are passed into the `count()` function, then Python raises a `TypeError`:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.count()

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
TypeError: tuple.count() takes exactly one argument (0 given)
"""
```

The next method we will look at is the `index()` method. This method is used to find the index where a particular item is present in a tuple. Here is an example of using the `index()` method to find the index for the string `Java`:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.index('Java') # 1
```

If the specified item cannot be found, then Python raises a `ValueError`:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.index('JavaScript')

"""
Traceback (most recent call last):
  File "<stdin>", line 2, in <module>
ValueError: tuple.index(x): x not in tuple
"""
```

Another thing you can do with the `index()` method is to pass in optional start and stop index arguments. Here is an example of passing in an optional start index:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust', 'Python')
programming_languages.index('Python', 3) # 5
```

In this example, we are specifying where to start searching for the string `Python`. By passing in the number `3` as the second argument to the `index()` function, we are specifying to start searching at index `3`. Since `Python` appears twice in the tuple, the `index()` function will return index `5` instead of index `2` because of the use of the optional start index argument.

You can also pass in an optional stop index. Here is a modified example of specifying a start and stop index:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust', 'Python', 'JavaScript', 'Python')
programming_languages.index('Python', 2, 5) # 2
```

Now the result is index `2` because we are starting the search at index `2`, and searching up to, but not including, index `5`.

Another commonly used function used with tuples is the `sorted()` function. In a previous lesson you learned about the `sort()` method for lists. Well, the `sorted()` function can be used on any iterable including tuples.

Here is an example of creating a new list of numbers using the `sorted()` function:

```py
numbers = (13, 2, 78, 3, 45, 67, 18, 7)
sorted(numbers) # [2, 3, 7, 13, 18, 45, 67, 78]
```

The `sorted()` function will always create a new list of the sorted values. This differs from the `sort()` method which sorts the elements of a list in place and does not return a new list.

If you need to customize the sorting behavior for an iterable, you can use the optional `reverse` and `key` arguments. Here is an example of using `key` argument to sort items in a tuple by length:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust', 'Python')
sorted(programming_languages, key=len)

# Result
# ['C++', 'Rust', 'Java', 'Rust', 'Python', 'Python']
```

If you want to create a new list of values in reverse order, then you can use the `reverse` argument like this:

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust', 'Python')

print(sorted(programming_languages, reverse=True))

# Result
# ['Rust', 'Rust', 'Python', 'Python', 'Java', 'C++']
```

Tuples are a common data type in Python. Understanding how to work with them, along with some helpful methods and functions, will help you write more efficient code.

# --questions--

## --text--

What will the following code return?

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.count('Rust')
```

## --answers--

`2`

---

`1`

### --feedback--

Review the beginning of the lesson for the answer.

---

`0`

### --feedback--

Review the beginning of the lesson for the answer.

---

`3`

### --feedback--

Review the beginning of the lesson for the answer.

## --video-solution--

1

## --text--

What will be the result for the following code?

```py
programming_languages = ('Rust', 'Java', 'Python', 'C++', 'Rust')
programming_languages.index('JavaScript')
```

## --answers--

`IndexError`

### --feedback--

Think about which type of error is appropriate to communicate that a value cannot be found.

---

`RangeError`

### --feedback--

Think about which type of error is appropriate to communicate that a value cannot be found.

---

`ValueError`

---

`SyntaxError`

### --feedback--

Think about which type of error is appropriate to communicate that a value cannot be found.

## --video-solution--

3

## --text--

Which of the following functions is used to return a new list of sorted results from an iterable?

## --answers--

`sorts()`

### --feedback--

Review the last part of the lesson for the answer.

---

`sorting()`

### --feedback--

Review the last part of the lesson for the answer.

---

`sort()`

### --feedback--

Review the last part of the lesson for the answer.

---

`sorted()`

## --video-solution--

4
