---
id: 6732c04638420641dcca2e6e
title: How Does the For...of Loop Work, and When Should You Use It?
challengeType: 19
dashedName: how-does-the-for-of-loop-work-and-when-should-you-use-it
---

# --interactive--

A `for...of` loop is used when you need to loop over values from an iterable. Examples of iterables would be arrays, and strings.

Here is the basic syntax for a `for...of` loop:

```js
for (variable of iterable) {
  // code block to be executed
}
```

The variable in the example represents the current value of the iterable that is being looped over.

If you have an array of numbers, the variable would be the current number in the array. If you have a string, the variable would be the current character in the string.

Let's take a look at a few examples so you can better understand how the `for...of` loop works.

In this first example we have an array of numbers and we want to loop over each number and log it to the console.

:::interactive_editor

```js
const numbers = [1, 2, 3, 4, 5];

for (const num of numbers) {
  console.log(num);
}
```

:::

We have created a variable called `num` that will represent the current number in the array. For iteration 1, `num` will be `1`, for iteration 2, `num` will be `2`, and so on.

Inside the loop, we are logging the current number to the console.

Here is another example where we have a string and we want to loop over each character and log it to the console.

:::interactive_editor

```js
const str = 'freeCodeCamp';

for (let char of str) {
  console.log(char);
}
```

:::

In this example, we have created a variable called `char` that will represent the current character in the string.

For each iteration, the loop will log the current character to the console.

It is important to note that you can use `let`, or `const` when declaring the variable in a `for...of` loop.

If you are going to use `const` though, make sure that the value of the variable does not change inside the loop. If it does, you will get an error.

Here is an example of using `const` that results in an error:

```js
const numbers = [1, 2, 3, 4, 5];

for (const num of numbers) {
  console.log(num);
  num = num + 1; // This will cause an error
}
```

In this example, we are trying to change the value of `num` inside the loop. Since we declared `num` with `const`, we will get an error. So, if you need to change the value of the variable inside the loop, use `let` instead.

Let's take a look at one last example dealing with an array of objects.

:::interactive_editor

```js
const people = [
  { name: 'John', age: 30 },
  { name: 'Jane', age: 25 },
  { name: 'Jim', age: 40 }
];

for (const person of people) {
  console.log(`${person.name} is ${person.age} years old`);
}
```

:::

In this example, we have an array of objects called `people`. Each object has a `name` and `age` property.

When we loop through the array, we create a variable called `person` that will represent the current object in the array.

Inside the loop, we are outputting a message to the console.

The first message will be `John is 30 years old`, the second message will be `Jane is 25 years old`, and the third message will be `Jim is 40 years old`.

`for...of` loops are really useful when you need to loop over values from an iterable like an array or a string. They are also easy to read and can make your code more concise.

# --questions--

## --text--

What will be the output of the following code?

```js
const colors = ['red', 'green', 'blue'];

for (const color of colors) {
  console.log(color);
}
```

## --answers--

```md
red
green
blue
```

---

```md
red
red
red
```

### --feedback--

Think about what the `color` variable represents in the loop.

---

```md
color
color
color
```

### --feedback--

Think about what the `color` variable represents in the loop.

---

```md
blue
blue
red
red
green
green
```

### --feedback--

Think about what the `color` variable represents in the loop.

## --video-solution--

1

## --text--

What happens if you try to reassign a value to a variable declared with `const` inside a `for...of` loop?

## --answers--

The value is reassigned successfully.

### --feedback--

Think about what `const` means and how it relates to reassigning values.

---

The loop will skip the iteration where the reassignment occurs.

### --feedback--

Think about what `const` means and how it relates to reassigning values.

---

An error will occur.

---

The loop will terminate immediately.

### --feedback--

Think about what `const` means and how it relates to reassigning values.

## --video-solution--

3

## --text--

In the following code snippet, what is logged to the console?

```js
const fruits = ['apple', 'banana', 'cherry'];

for (let fruit of fruits) {
  console.log(fruit.toUpperCase());
}
```

## --answers--

```md
APPLE
APPLE
APPLE
```

### --feedback--

Think about what the fruit variable represents in the loop and how the `toUpperCase` method works.

---

```md
apple
banana
cherry
```

### --feedback--

Think about what the fruit variable represents in the loop and how the `toUpperCase` method works.

---

```md
APPLE
BANANA
CHERRY
```

---

```md
FRUIT
FRUIT
FRUIT
```

### --feedback--

Think about what the fruit variable represents in the loop and how the `toUpperCase` method works.

## --video-solution--

3
