---
id: 688170ebc58d8d3b1ae493a2
title: What Is Nano?
challengeType: 19
dashedName: what-is-nano
---

# --description--

When working in the terminal, standard text editors aren't always available, but there are programs designed to edit files directly from within the terminal.

Linux environments typically include a text editor. Vi, or Vim, tend to be the most common. Emacs and Nano may need to be installed manually, but they are readily available for nearly every distribution.

The challenge with Vim is it has a substantial learning curve. If you are not already familiar with it, you may not even know how to close the application! Emacs is arguably a bit more user friendly, but still has its own tome of keyboard shortcuts.

Nano is considerably more streamlined and user-friendly, especially for new learners. It can be much quicker to dive in and edit a file with Nano, and the application even offers on-screen help for the basic keyboard shortcuts.

The tradeoff for this, however, is the lack of extensibility. Unlike Vim or Emacs, which can be extended with plugins to become full development environments, Nano is rather barebones.

Let's take a peek at what Nano can do. To open a file, you can enter `nano <filename>` in the terminal.

Once a file is open, you will see the version of Nano you are running and the name of the file you have open at the top of the screen.

Below that is the content of the file. You can use the arrow keys to navigate your cursor and insert or delete text with your keyboard. The file will scroll as needed to follow.

Then, at the bottom, you will see a list of available keyboard shortcuts, that looks something like this:

```bash
^G Help   ^O Write Out    ^F Where Is   ^K Cut      ^T Execute  ^C Location     M-U Undo    M-A Set Mark    M-] To Bracket    M-B Previous
^X Exit   ^R Read File    ^\ Replace    ^U Paste    ^J Justify  ^/ Go To Line   M-E Redo    M-6 Copy        ^B Where Was      M-F Next
```

Shortcuts which start with the caret (`^`) symbol indicate you need to hold the Ctrl key and press the indicated letter. Shortcuts which start with `M-` require you to hold the "meta key", which in most setups should be the Alt key, and press the letter.

To edit a file in Nano, you only need to know a few of the shortcut commands. After making changes to a file, you can press `Ctrl + O` to "Write Out", or save, the file. After entering the command, you will see the menu at the bottom change to this:

```bash
File Name to write : <filename>
^G Get Help                 ^T  To Files
^C Cancel                   TAB Complete
```

Press enter to save the file and go back to editing the file, or `Ctrl + C` to cancel and go back to editing the file.

While in the editor, you can press `Ctrl + X` to exit Nano and go back to the terminal. If you have unsaved changes when trying to exit, you will see this in the bottom menu:

```bash
Save modified buffer (ANSWERING "No" WILL DESTROY CHANGES) ?
                            Y Yes
^C Cancel                   N No
```

Press `Y` to save your unsaved changes, or `N` to discard them.

With this knowledge, you should be better prepared the next time you need to quickly edit a file on a remote server, where you might not have access to a full graphical environment.

# --questions--

## --text--

What makes Nano different from editors like Vim and Emacs?

## --answers--

It has a steeper learning curve.

### --feedback--

Think about the advantages and disadvantages of Nano mentioned in the lesson.

---

It's more extensible with plugins.

### --feedback--

Think about the advantages and disadvantages of Nano mentioned in the lesson.

---

It's more user-friendly with on-screen keyboard shortcuts.

---

It's not available on most Linux distributions.

### --feedback--

Think about the advantages and disadvantages of Nano mentioned in the lesson.

## --video-solution--

3

## --text--

In Nano's interface, what does the caret (`^`) symbol before a key indicate?

## --answers--

Press the `Shift` key and the indicated letter.

### --feedback--

The lesson explains how to interpret the keyboard shortcuts shown at the bottom of the Nano interface.

---

Press the Control (`Ctrl`) key and the indicated letter.

---

Press the `Alt` key and the indicated letter.

### --feedback--

The lesson explains how to interpret the keyboard shortcuts shown at the bottom of the Nano interface.

---

Press the indicated letter twice quickly.

### --feedback--

The lesson explains how to interpret the keyboard shortcuts shown at the bottom of the Nano interface.

## --video-solution--

2

## --text--

What keyboard shortcut is used to save changes to a file in Nano?

## --answers--

`Ctrl + Q`

### --feedback--

Find where the lesson mentions how to save the file.

---

`Ctrl + X`

### --feedback--

Find where the lesson mentions how to save the file.

---

`Ctrl + G`

### --feedback--

Find where the lesson mentions how to save the file.

---

`Ctrl + O`

## --video-solution--

4
