---
id: 673271884bf678d8b9c64f56
title: What Are the Different Arithmetic Operators in JavaScript?
challengeType: 19
dashedName: what-are-the-different-arithmetic-operators-in-javascript
---

# --interactive--

JavaScript provides tools to perform basic arithmetic operations on numbers, such as addition, subtraction, multiplication, and division. JavaScript also includes operators for more complex arithmetic operations, such as remainder and exponentiation.

All these tools are called arithmetic operators. Let's look at these operators in detail, how to use them and how to combine them. 

The addition operator is a plus sign (`+`). The addition operator allows you to find the total of two or more numbers. In addition operations, the order of the numbers doesn't matter:

:::interactive_editor

```js
const num1 = 10;
const num2 = 5;
const num3 = 15;

const result1 = num1 + num2;
const result2 = num2 + num1;
const result3 = num2 + num1 + num3;

console.log(result1); // 15
console.log(result2); // 15
console.log(result3); // 30
```

:::

The subtraction operator is a minus sign (`-`). It allows you to find the difference between two numbers. Use the minus sign when you want to subtract a number from another number, usually a smaller one from a bigger one:

:::interactive_editor

```js
const difference = 10 - 5;
console.log(difference); // 5
```

:::

If a smaller number comes first, you'll get a negative result:

:::interactive_editor

```js
const difference = 5 - 10;
console.log(difference); // -5
```

:::

You can also assign the numbers to variables and do the subtraction with the variable names:

:::interactive_editor

```js
const num1 = 10;
const num2 = 5;
const result = num1 - num2;

console.log(result); // 5
```

:::

In JavaScript, the multiplication operator is represented by an asterisk (`*`) and is used to find the product of two or more numbers. The order of the numbers you're multiplying does not matter:

:::interactive_editor

```js
const num1 = 10;
const num2 = 5;
const num3 = 15;

const result1 = num1 * num2;
const result2 = num2 * num1;
const result3 = num2 * num1 * num3;

console.log(result1); // 50
console.log(result2); // 50
console.log(result3); // 750
```

:::

In JavaScript, the division operator is a slash (`/`), which differs from the division symbol used in traditional math (`÷`). You perform division operations with the division operator. The order of the numbers you're dividing matters in this case:

:::interactive_editor

```js
const num1 = 10;
const num2 = 5;
const num3 = 15;

const result1 = num1 / num2;
const result2 = num2 / num1;
const result3 = num2 / num1 / num3;

console.log(result1); // 2
console.log(result2); // 0.5
console.log(result3); // 0.03333333333333333
```

:::

It's important to note that if you try to divide by zero, JavaScript will return `Infinity`:

:::interactive_editor

```js
const result = 10 / 0; 

console.log(result); // Infinity
```

:::

Make sure to avoid those types of calculations so you don't end up with unexpected results in your code. 

The remainder operator, represented by a percentage sign (`%`), returns the remainder of a division. The remainder in math is the leftover value after performing division:

:::interactive_editor

```js
const num1 = 10;
const num2 = 3;
const remainder = num1 % num2;

console.log(remainder); // 1
```

:::

The exponentiation operator, represented by a double asterisk (`**`), raises one number to the power of another:

:::interactive_editor

```js
const num1 = 2;
const num2 = 3;

const exponent = num1 ** num2;
console.log(exponent); // 8
```

:::

It's possible to mix operators in a single operation or expression:

:::interactive_editor

```js
const result = 10 + 5 * 2 - 8 / 4;
console.log(result); // 18
```

:::

When you mix different operators in a single expression, the JavaScript engine follows a system called operator precedence to determine the order of operations. Operator precedence determines the order in which operations are executed in expressions. You will learn more about operator precedence in future lessons.

# --questions--

## --text--

Which of the following operators should you use to subtract one number from another?

## --answers--

`+`

### --feedback--

Think about the symbol typically used for subtraction.

---

`-`

---

`*`

### --feedback--

Think about the symbol typically used for subtraction.

---

`/`

### --feedback--

Think about the symbol typically used for subtraction.

## --video-solution--

2

## --text--

What’s the output of the following code?

```js
const result = 4 / 0;
console.log(result);
```

## --answers--

`Infinity`

---

`4`

### --feedback--

Recall the special value JavaScript returns when you divide by zero.

---

`1`

### --feedback--

Recall the special value JavaScript returns when you divide by zero.

---

`16`

### --feedback--

Recall the special value JavaScript returns when you divide by zero.

## --video-solution--

1

## --text--

What’s the output of the following code?

```js
const remainder = 5 % 3;
console.log(remainder);
```

## --answers--

`15`

### --feedback--

Remember that `%` is the remainder operator, so another way to think of the equation is, after `3` goes into `5` once, what’s left?

---

`2`

---

`3`

### --feedback--

Remember that `%` is the remainder operator, so another way to think of the equation is, after `3` goes into `5` once, what’s left?

---

`1.6666666666666667`

### --feedback--

Remember that `%` is the remainder operator, so another way to think of the equation is, after `3` goes into `5` once, what’s left?

## --video-solution--

2
