---
id: 67327195e77b1bd90bdd49d7
title: What Happens When You Try to Do Calculations with Numbers and Strings?
challengeType: 19
dashedName: what-happens-when-you-try-to-do-calculations-with-numbers-and-strings
---

# --interactive--

JavaScript is a language where things sometimes work in surprising, or even weird, ways. One such surprise occurs when you mix numbers and strings in calculations. The first thing you'll probably try is to add a number and a string. In JavaScript, the `+` operator does double duty. It handles both addition and string concatenation, which is a way to join two strings together.

When you use `+` with a number and a string, JavaScript decides to treat them both as strings and joins them together. If you check the type of the result with the `typeof` operator, you'd see it's indeed a string:

:::interactive_editor

```js
const result = 5 + '10';

console.log(result); // 510
console.log(typeof result); // string
```

:::

What do you think will happen if you switch the order of `5` and `'10'`?

:::interactive_editor

```js
const result = '10' + 5;

console.log(result); // 105
console.log(typeof result); // string
```

:::

You can see the same thing happened. JavaScript sees a string in `'10'` and a number in `5`, so it converts the number to a string and concatenates them. This is known as type coercion. Type coercion is when a value from one data type is converted into another.

Things get more interesting when you try to perform other arithmetic operations like subtraction, multiplication, or division with a string and number. In these cases, JavaScript tries to convert the string into a number before doing the math – another type coercion! Here's what happens:

:::interactive_editor

```js
const subtractionResult = '10' - 5;
console.log(subtractionResult); // 5
console.log(typeof subtractionResult); // number

const multiplicationResult = '10' * 2;
console.log(multiplicationResult); // 20
console.log(typeof multiplicationResult); // number

const divisionResult = '20' / 2;
console.log(divisionResult); // 10
console.log(typeof divisionResult); // number
```

:::

In the examples above, JavaScript successfully converts the string `'10'` or `'20'` to a number and then performs the calculation. As a result, `'10' - 5` yields `5`, `'10' * 2` gives `20`, and `'20' / 2` results in `10`.

But what if the string doesn't look like a number? Let's see what happens in that case:

:::interactive_editor

```js
const subtractionResult = 'abc' - 5;
console.log(subtractionResult); // NaN
console.log(typeof subtractionResult); // number

const multiplicationResult = 'abc' * 2;
console.log(multiplicationResult); // NaN
console.log(typeof multiplicationResult); // number

const divisionResult = 'abc' / 2;
console.log(divisionResult); // NaN
console.log(typeof divisionResult); // number
```

:::

In the examples above, the string `'abc'` does not represent a valid numeric value, so JavaScript cannot convert it into a meaningful number. When such conversion fails, JavaScript returns `NaN`, which stands for "Not a Number". `NaN` is a special value of the `Number` type that represents an invalid or unrepresentable number.

What if you perform arithmetic operations with a boolean (`true` or `false`)? Let's see what happens. JavaScript treats booleans as numbers in mathematical operations: `true` becomes `1`, and `false` becomes `0`.

:::interactive_editor

```js
const result1 = true + 1;
console.log(result1); // 2
console.log(typeof result1); // number

const result2 = false + 1;
console.log(result2); // 1
console.log(typeof result2); // number

const result3 = 'Hello' + true;
console.log(result3); // "Hellotrue"
console.log(typeof result3); // string
```

:::

In the first two examples, `true + 1` resulted in `2`, and `false + 1` resulted in `1`. In the third example, `'Hello' + true`, JavaScript converted `true` to a string and concatenates it with `'Hello'`, resulting in `'Hellotrue'`, which is a string.

For `null` and `undefined`, JavaScript treats `null` as `0` and `undefined` as `NaN` in mathematical operations:

:::interactive_editor

```js
const result1 = null + 5;
console.log(result1); // 5
console.log(typeof result1); // number

const result2 = undefined + 5;
console.log(result2); // NaN
console.log(typeof result2); // number
```

:::

JavaScript often performs type coercion, automatically converting data types such as numbers, strings, and booleans in sometimes unexpected ways. Understanding these conversions is crucial for avoiding bugs and writing robust code in your projects.

# --questions--

## --text--

What happens when you run the following code?

```js
const result = 3 + "19";
```

## --answers--

JavaScript ignores the string and only performs the operation on the number.

### --feedback--

Recall how type coercion works for addition operations, and how you use the same symbol to combine strings.

---

JavaScript throws an error when you try to mix strings and numbers in arithmetic.

### --feedback--

Recall how type coercion works for addition operations, and how you use the same symbol to combine strings.

---

JavaScript converts the number `3` into the string `"3"`, concatenates the two strings, and assigns the value `"319"` to `result`.

---

JavaScript converts the string `"19"` into the number `19`, performs the operation, and assigns the value `22` to `result`.

### --feedback--

Recall how type coercion works for addition operations, and how you use the same symbol to combine strings.

## --video-solution--

3

## --text--

What happens when you run the following code?

```js
const result = "6" - 4;
```

## --answers--

Conversion fails and JavaScript returns `NaN`.

### --feedback--

Recall how type coercion works for subtraction, multiplication, division, and other kinds of operations.

---

JavaScript converts the number `4` into the string `"4"`, concatenates the two strings, and assigns the value `"64"` to `result`.

### --feedback--

Recall how type coercion works for subtraction, multiplication, division, and other kinds of operations.

---

The value `Infinity` is assigned to `result`.

### --feedback--

Recall how type coercion works for subtraction, multiplication, division, and other kinds of operations.

---

JavaScript converts the string `"6"` into the number `6`, performs the operation, and assigns the value `2` to `result`.

## --video-solution--

4

## --text--

What happens when you perform arithmetic operations with a boolean (`true` or `false`) in JavaScript?

## --answers--

JavaScript throws an error.

### --feedback--

Consider how JavaScript interprets `true` and `false` in numerical contexts.

---

JavaScript ignores the boolean and only performs the operation on numbers.

### --feedback--

Consider how JavaScript interprets `true` and `false` in numerical contexts.

---

JavaScript treats `true` as `1` and `false` as `0` in arithmetic operations.

---

JavaScript converts the boolean to a string before performing the operation.

### --feedback--

Consider how JavaScript interprets `true` and `false` in numerical contexts.

## --video-solution--

3
