---
id: 6732719e2e3ad4d947410b65
title: How Does Operator Precedence Work?
challengeType: 19
dashedName: how-does-operator-precedence-work
---

# --interactive--

If you write an expression with several operators in JavaScript, how does JavaScript decide which one to evaluate first? This is where operator precedence comes in. Let's explore operator precedence in detail with code examples, and also what happens when operators have the same precedence.

Operator precedence determines the order in which operations are evaluated in an expression. Operators with higher precedence are evaluated before those with lower precedence. Think of operator precedence like in math, where division and multiplication happen before addition and subtraction.

Without following this rule, basic equations would give you the wrong answer. JavaScript works the same way. It has its own rules for which operators come first, second, and so on. For example, take a look at the expression below:

:::interactive_editor

```js
const result = 2 + 3 * 4;

console.log(result); // 14
```

:::

If JavaScript evaluated this expression from left to right, you'd expect `2 + 3 = 5`, then `5 * 4 = 20`. But because multiplication has a higher precedence than addition, JavaScript evaluates the `3 * 4` part first, resulting in `2 + 12 = 14`. 

Sometimes, you may want certain parts of your expression to run first, regardless of precedence rules. You can use parentheses, `()`, to do this. Anything inside parentheses is evaluated first, no matter what. Let's make the `2 + 3` part of the previous example evaluate first:

:::interactive_editor

```js
const result = (2 + 3) * 4;

console.log(result); // 20
```

:::

In the example above, the parentheses force JavaScript to evaluate `2 + 3` first, and then multiply the result by `4`. This gives you `20` instead of `14`.

The division operator has more precedence than addition or subtraction too:

:::interactive_editor

```js
const result = 2 + 6 / 3;

console.log(result); // 4
```

:::

If JavaScript evaluated this expression from left to right, you might expect `2 + 6 = 8`, then `8 / 3 = 2.67`. But since division has a higher precedence than addition, JavaScript evaluates the division first: `6 / 3 = 2`, and then adds `2 + 2`, giving the result `4`.

So, in both multiplication and division, those operations will always take place before addition and subtraction unless you use parentheses to change the order. So what happens if the operators have the same precedence? JavaScript uses associativity to figure out the order to evaluate them.

Associativity is what tells JavaScript whether to evaluate operators from left to right or right to left. For most operators like addition and multiplication, associativity is left to right. So, JavaScript processes these from the leftmost side of the expression to the right:

:::interactive_editor

```js
const result = 10 - 2 + 3;

console.log(result); // 11
```

:::

First, `10 - 2 = 8`, then `8 + 3 = 11`. JavaScript moves left to right in this case. Some operators, like assignment (`=`), are right-to-left associative. This means the right side of the expression gets evaluated first:

:::interactive_editor

```js
let a, b;
a = b = 5;

console.log(a); // 5
console.log(b); // 5
console.log(a + b); // 10
```

:::

In the example above, JavaScript assigns `5` to `b` first, then assigns `b` (which is now `5`) to `a`.

The exponent operator is also right-to-left associative:

:::interactive_editor

```js
const result = 2 ** 3 ** 2;

console.log(result); // 512
```

:::

First, JavaScript evaluates `3 ** 2`, which equals `9`, then, it evaluates `2 ** 9`, which equals `512`. If the exponent operator had left-to-right associativity, JavaScript would have calculated `2 ** 3` first to get `8`, then `8 ** 2` to get `64`. 

# --questions--

## --text--

How does operator precedence in JavaScript compare to mathematics?

## --answers--

Addition happens before multiplication and division.

### --feedback--

Think about the order of operations you follow in math equations.

---

Division and multiplication happen before addition and subtraction, just like in mathematics.

---

All operations are performed in the order they appear.

### --feedback--

Think about the order of operations you follow in math equations.

---

Subtraction takes precedence over all other operations.

### --feedback--

Think about the order of operations you follow in math equations.

## --video-solution--

2

## --text--

How can you override operator precedence in JavaScript?

## --answers--

By using the addition operator (`+`) to change the order of operations.

### --feedback--

Think about how you change the order of operations in math equations.

---

By using parentheses to force certain parts of the expression to be evaluated first.

---

By reversing the operators in the expression.

### --feedback--

Think about how you change the order of operations in math equations.

---

By performing all operations left to right, regardless of precedence.

### --feedback--

Think about how you change the order of operations in math equations.

## --video-solution--

2

## --text--

How does JavaScript evaluate expressions with the exponent operator (`**`)?

## --answers--

From left to right.

### --feedback--

Think about the order in which exponentiation occurs in the expression.

---

From right to left, meaning it evaluates the rightmost exponentiation first.

---

By multiplying the base by itself the number of times indicated.

### --feedback--

Think about the order in which exponentiation occurs in the expression.

---

By adding the exponents together first, then calculating the result.

### --feedback--

Think about the order in which exponentiation occurs in the expression.

## --video-solution--

2
