---
id: 6732b77adf9de12617a2dbb3
title: What Is Object Destructuring, and How Does It Work?
challengeType: 19
dashedName: what-is-object-destructuring-and-how-does-it-work
---

# --interactive--

Object destructuring is a powerful feature in JavaScript that allows you to extract values from objects and assign them to variables in a more concise and readable way. 

It's part of the ES6 (ECMAScript 2015) specification and has become an essential tool for many JavaScript developers. 

Destructuring can simplify your code, especially when working with complex objects or when you need to extract multiple values at once.

At its core, object destructuring is about unpacking values from objects into distinct variables. Instead of accessing object properties one by one, you can extract multiple properties in a single statement. This can make your code cleaner and more efficient.

Let's start with an example to illustrate how object destructuring works:

:::interactive_editor

```js
const person = { name: "Alice", age: 30, city: "New York" };

const { name, age } = person;

console.log(name); // Alice
console.log(age);  // 30
```

:::

In this example, we're extracting the `name` and `age` properties from the `person` object and assigning them to variables with the same names. 

One of the powerful aspects of object destructuring is that you can assign the extracted values to variables with different names. This is particularly useful when you're working with objects that have property names that might conflict with existing variables or when you want to use a different name:

:::interactive_editor

```js
let person = { name: "Alice", age: 30, city: "New York" };

let { name: personName, age: personAge } = person;

console.log(personName); // Alice
console.log(personAge); //  30
```

:::

In this case, we're extracting the `name` property and assigning it to a variable called `personName`, and doing the same with `age` and `personAge`.

Object destructuring also allows you to set default values. If a property doesn't exist in the object you're destructuring, you can specify a fallback value:

:::interactive_editor

```js
let person = { name: "Alice", age: 30, city: "New York" };
let { name, age, country = "Unknown" } = person;

console.log(country); // Unknown
```

:::

Here, since `country` doesn't exist in our `person` object, it gets the default value `Unknown`.

Another common case is nested object destructuring. You can destructure properties nested inside other objects by using another set of braces:

:::interactive_editor

```js
const recipe = {
  name: "Chocolate Cake",
  ingredients: {
    flour: "2 cups",
    sugar: "1 cup"
  }
};

// Extract `flour` from `ingredients`
const { ingredients: { flour } } = recipe;

console.log(flour); // "2 cups"
```

:::

This is equivalent to accessing the property directly:

```js
const flour = recipe.ingredients.flour;
console.log(flour); // "2 cups"
```

Now, let's talk about the shorthand notation in object destructuring. When you're creating objects, especially when the property names match variable names, you can use a shorthand syntax:

:::interactive_editor

```js
let name = "Bob";
let age = 25;

let person = { name, age };

console.log(person); // { name: "Bob", age: 25 }
```

:::

The code above takes the properties with the same name as our variables and assigns them the values of those variables.

This shorthand notation is particularly useful when you're returning objects from functions or creating objects with multiple properties:

:::interactive_editor

```js
function createPerson(name, age) {
  return { name, age };
}

let person = createPerson("Charlie", 35);
console.log(person); // { name: "Charlie", age: 35 }
```

:::

Object destructuring and the shorthand object notation are powerful features that can make your code more concise and easier to read. 

They're especially useful when working with complex data structures, or when you need to pass multiple parameters to functions. 

As you continue to work with JavaScript, you'll find many situations where these techniques can simplify your code and make it more expressive.

# --questions--

## --text--

What is the primary purpose of object destructuring in JavaScript?

## --answers--

To create new objects.

### --feedback--

Think about what we said destructuring allows you to do with object properties.

---

To extract values from objects and assign them to variables.

---

To merge multiple objects.

### --feedback--

Think about what we said destructuring allows you to do with object properties.

---

To delete properties from objects.

### --feedback--

Think about what we said destructuring allows you to do with object properties.

## --video-solution--

2

## --text--

How can you assign a default value to a variable when destructuring an object?

## --answers--

`{ property = defaultValue } = object`

---

`{ property: defaultValue } = object`

### --feedback--

Recall the syntax we used to provide a fallback value for non-existent properties.

---

`{ property || defaultValue } = object`

### --feedback--

Recall the syntax we used to provide a fallback value for non-existent properties.

---

`{ property ? defaultValue } = object`

### --feedback--

Recall the syntax we used to provide a fallback value for non-existent properties.

## --video-solution--

1

## --text--

What does the shorthand notation `{ name, age }` do when creating an object?

## --answers--

It creates an object with `undefined` properties.

### --feedback--

Remember what we said about the shorthand syntax when property names match variable names.

---

It creates an object with `null` values for `name` and `age`.

### --feedback--

Remember what we said about the shorthand syntax when property names match variable names.

---

It creates an object with properties named `name` and `age`, assigning them the values of variables with the same names.

---

It throws an error because it's invalid syntax.

### --feedback--

Remember what we said about the shorthand syntax when property names match variable names.

## --video-solution--

3
