---
id: 6733c5dc74176e4c496d09e6
title: What Are Lookahead and Lookbehind Assertions, and How Do They Work?
challengeType: 19
dashedName: what-are-lookaheads-and-lookbehind-assertions-and-how-do-they-work
---

# --interactive--

Lookahead and lookbehind assertions allow you to match specific patterns based on the presence or lack of surrounding patterns. There are four variations of these assertions.

First is the positive lookahead assertion. This assertion will match a pattern when the pattern is followed by another pattern.

To construct a positive lookahead, you need to start with the pattern you want to match. Then, use parentheses to wrap the pattern you want to use as your condition. After the opening parenthesis, use `?=` to define that pattern as a positive lookahead.

This pattern will only match the word `free` if it is followed by `code`:

```js
const regex = /free(?=code)/i;
```

Let's test the behavior of our pattern:

:::interactive_editor

```js
const regex = /free(?=code)/i;
console.log(regex.test("freeCodeCamp")); // true
console.log(regex.test("free code camp")); // false
console.log(
  regex.test("I need someone for free to write code for me")
); // false
```

:::

Notice how only the string where `free` is immediately followed by `code` passes the test.

But what if you want to match the presence of `free` when it is NOT followed by `code`? You can turn your positive lookahead into a negative lookahead to invert the behavior. To do this, change your `?=` to `?!`:

```js
const regex = /free(?!code)/i;
```

Let's test this against our same strings:

:::interactive_editor

```js
const regex = /free(?!code)/i;
console.log(regex.test("freeCodeCamp")); // false
console.log(regex.test("free code camp")); // true
console.log(
  regex.test("I need someone for free to write code for me")
); // true
```

:::

As expected, the results are reversed. The only string that fails is the first string, where `free` is immediately followed by `code`.

Lookbehind assertions function similarly to lookahead assertions, except that, instead of matching conditionally based on a following pattern, they match conditionally based on a preceding pattern. Let's take a look at a positive lookbehind.

A positive lookbehind is denoted with `?<=` instead of `?=`. Let's make our regular expression match `code` when it is preceded by `free`:

```js
const regex = /(?<=free)code/i;
```

Just like with our positive lookahead, our positive lookbehind matches the first string because `code` is immediately preceded by `free`:

:::interactive_editor

```js
const regex = /(?<=free)code/i;
console.log(regex.test("freeCodeCamp")); // true
console.log(regex.test("free code camp")); // false
console.log(
  regex.test("I need someone for free to write code for me")
); // false
```

:::

To match `code` when it is NOT preceded by `free`, we can use a negative lookbehind. A negative lookbehind is defined by replacing `?<=` with `?<!`:

```js
const regex = /(?<!free)code/i;
```

This would match any occurrence of `code` that is NOT immediately preceded by `free`:

:::interactive_editor

```js
const regex = /(?<!free)code/i;
console.log(regex.test("freeCodeCamp")); // false
console.log(regex.test("free code camp")); // true
console.log(
  regex.test("I need someone for free to write code for me")
); // true
```

:::

Remember that `Regex.prototype.test` only confirms whether a string matches the regular expression. Let's use our negative lookbehind with `String.prototype.match` to see how assertions affect that:

```js
const regex = /(?<!free)code/i;
console.log("freeCodeCamp".match(regex)); // null
console.log("free code camp".match(regex)); // ['code', index: 5, input: 'free code camp', groups: undefined]
console.log(
  "I need someone for free to write code for me".match(regex)
); // ['code', index: 33, input: 'I need someone for free to write code for me', groups: undefined]
```

Notice how even though our regular expression uses a lookbehind to check for the presence of `free`, it does not match `free`. The only text included in the match is `code`.

Lookaheads and lookbehinds are incredibly useful for conditionally matching text without impacting the returned value of your match.

# --questions--

## --text--

What is the syntax for a positive lookahead assertion in a regular expression?

## --answers--

`(?=pattern)`

---

`(?<=pattern)`

### --feedback--

The lesson describes how to construct a positive lookahead using a specific syntax.

---

`(?!pattern)`

### --feedback--

The lesson describes how to construct a positive lookahead using a specific syntax.

---

`(?<!pattern)`

### --feedback--

The lesson describes how to construct a positive lookahead using a specific syntax.

## --video-solution--

1

## --text--

Which assertion would you use to match a word only if it is NOT followed by a specific pattern?

## --answers--

Positive lookahead.

### --feedback--

Think about which assertion "inverts" the behavior of a positive lookahead.

---

Negative lookahead.

---

Positive lookbehind.

### --feedback--

Think about which assertion "inverts" the behavior of a positive lookahead.

---

Negative lookbehind.

### --feedback--

Think about which assertion "inverts" the behavior of a positive lookahead.

## --video-solution--

2

## --text--

When using a lookbehind assertion with `String.prototype.match`, what part of the string is actually included in the match result?

## --answers--

The entire string.

### --feedback--

The lesson demonstrates this with an example using a negative lookbehind.

---

The pattern in the lookbehind assertion.

### --feedback--

The lesson demonstrates this with an example using a negative lookbehind.

---

The pattern after the lookbehind assertion.

---

Both the lookbehind pattern and the pattern after it.

### --feedback--

The lesson demonstrates this with an example using a negative lookbehind.

## --video-solution--

3
