---
id: 687ea6c021dd5913cf8fd8dd
title: What Are Relational Databases, and How Do They Differ from Non-Relational Databases?
challengeType: 19
dashedName: what-are-relational-databases-and-how-do-they-differ-from-non-relational-databases
---

# --description--

A relational database is a collection of data organized into tables. These tables are made of rows and columns.

Rows represent individual records. For example, if you're storing user data, each row could represent a specific user.

Columns represent the attributes or fields that describe each record. The table might include columns for common user attributes, such as name and national ID number.

One of the key characteristics of relational databases is that they allow us to connect different pieces of information by linking tables through common attributes, making it easier to see how they relate to each other.

Relational databases require a schema. The schema defines the overall structure of the database, including its tables, columns, data types, relationships, and constraints.

All tables in a relational database have a primary key, which is a unique identifier for each row. They enable relationships between tables via foreign keys. You'll learn more about primary keys, foreign keys, and how they work in the coming lessons. For now, just know they are fundamental to linking records across tables.

For example, let's say that you're creating a database for an organization that runs a wildlife conservation center for critically endangered animals.

One of the tables could store general information about the animals, you might call it `animals`. Each row could represent an animal, while each column could represent an attribute of that animal, like species, size, weight, age, and other unique characteristics.

To uniquely identify each animal, you would typically add an `id` column to the table. This would be the primary key of the table because it's unique for each animal. The ID of each animal could be used to link its record in this table to related records in other tables.

You could also have a `species` table to store information about each species, such as their habitat and conservation status. Each animal in the `animals` table could reference a species from this table using a species ID.

You could also create a table to store the veterinary records of the animals. This way, the center can track their health, treatments, and medications.

Once you have this general schema, you could link these tables to the `animals` table, which acts as the central point for animal-related data.

This way, you don't have to keep all the information about an animal in the same table. Instead, you can store related data in separate tables and link them through relationships. By creating these relationships, you can get the specific data you need with a single query.

A query is a request for specific data from the database. Examples of queries that you could make in the context of our example would be finding all animals that need a veterinary checkup, finding the most critically endangered species in the center, finding the number of animals who were born in captivity, and more. You can customize the queries to fit your needs.

Our example was related to wildlife conservation, but relational databases have a wide range of applications across industries such as healthcare, construction, business, gaming, education, government, e-commerce, social media, and more.

They offer several advantages, including scalability. They can handle large datasets, so they're perfect for complex, real-world applications. They also enforce data integrity through primary keys, foreign keys, and data types, which ensures that the data will be consistent and accurate.

In addition to relational databases, you can work with non-relational databases.

The main difference between relational and non-relational databases is how the data is stored. Non-relational databases, also known as NoSQL databases, are more flexible. They store data in individual files that are not connected. Their data model is more flexible too.

While some non-relational databases may have a basic schema or data model, it is often less rigid than the schema defined in relational databases. You can add, modify, or remove data fields if necessary.

The decision to use a relational or non-relational database depends on various factors, including the nature of the data and the specific requirements of the application. You should evaluate the tradeoffs between these two approaches to choose the best one for your application.

# --questions--

## --text--

Which of the following is a key characteristic of relational databases?

## --answers--

Flexible schema

### --feedback--

Think about how data is organized in relational databases.

---

Document-based structure

### --feedback--

Think about how data is organized in relational databases.

---

Key-value pairs

### --feedback--

Think about how data is organized in relational databases.

---

Structured data in tables

## --video-solution--

4

## --text--

Which of the following statements is true about relational databases?

## --answers--

They are always more scalable than non-relational databases.

### --feedback--

Think about the structure and characteristics of relational databases.

---

They are always more performant than non-relational databases.

### --feedback--

Think about the structure and characteristics of relational databases.

---

They require a predefined schema.

---

They are not suitable for large-scale applications.

### --feedback--

Think about the structure and characteristics of relational databases.

## --video-solution--

3

## --text--

Which of the following statements is true about non-relational databases?

## --answers--

They always have a fixed schema.

### --feedback--

Think about the key differences between relational and non-relational databases.

---

They are not suitable for large-scale applications.

### --feedback--

Think about the key differences between relational and non-relational databases.

---

They allow for more flexible data modeling.

---

They are always slower than relational databases.

### --feedback--

Think about the key differences between relational and non-relational databases.

## --video-solution--

3
