---
id: 687ea8757080091969f07122
title: What Is SQL, and How Can You Create a Database with Tables?
challengeType: 19
dashedName: what-is-sql-and-how-can-you-create-a-database-with-tables
---

# --description--

SQL stands for Structured Query Language. It was developed in the 1970s, when it was initially known as the structured English query language (SEQUEL). This term was later shortened to SQL.

SQL is a programming language used for storing and managing data in relational databases.

Like you learned in a previous lesson, relational databases organize data into tables. Each table has a set of rows and columns, where the data attributes and their relationships are represented. Each row represents a record while each column represents a specific attribute or field of that record.

With SQL, you can add, change, delete, find, and retrieve data from a relational database. It provides a comprehensive set of commands for querying, filtering, sorting, and aggregating data.

SQL can help optimize database performance, by querying only the necessary data, and it can be easily integrated with a wide range of programming languages, so you can use it to interact with databases directly from your applications.

It has been also adopted as an industry standard. It enforces data integrity and includes many security features, like support for user authentication and data encryption.

It's also scalable, portable, and compatible with a wide range of database management systems.

SQL is based on commands, commonly known as SQL statements or SQL queries.

As a developer, you will write these statements using specific SQL language elements or keywords. They allow you to perform the necessary operations on your database.

Before you can enter SQL commands, you need to open the psql shell so you can directly interact with the PostgreSQL database. In the command prompt or terminal, enter:

```bash
psql -U <username> -d <database_name>
```

Replace `username` with your username and `database_name` with the database you want to connect to. If you haven't created own your database yet, use `postgres`, it comes with the installation.

Once connected, you will see the prompt change to:

```bash
postgres=#
```

It shows the database name you are connected to and waits for SQL commands.

Let's go over some of the most fundamental SQL commands that you should be familiar with. You'll notice that, by convention, SQL commands end with a semicolon (`;`).

First, you can use this command to create a database named `my_database`:

```sql
CREATE DATABASE my_database;
```

You can type `CREATE` followed by `DATABASE`, and the name of the database that you want to create. Notice that the SQL keywords of the command are written in capital letters.

Then, once you have your database, you can connect to it.

How you connect to the database really depends on the environment and tool you're using.

In the command prompt or terminal, you can use the method shown earlier. In the interactive psql shell, you can switch databases with the `\c` shortcut command followed by the database name like this:

```bash
\c my_database
```

Note that the `\c` command and other shortcut commands (ones with a backslash in front of them) are part of the psql shell and not part of the SQL language itself, so they do not require a semi-colon to complete the command.

Now that you've connected to your new database, you will see the prompt has changed:

```bash
my_database=#
```

Once you have created and connected to a database, you can create a table with the `CREATE TABLE` keywords:

```sql
CREATE TABLE products (
  id SERIAL,
  name VARCHAR(255)
);
```

In the command, you write `CREATE TABLE`, followed by the name of the table that you want to create. In this case, it will create a table named `products`.

Then, within parentheses, you write the names of the columns that the table should have and specify the data type of the values that will be stored in each column.

In the example, the table will have two columns, a column for the product ID and another one for the name of the product.

The standard naming convention for table and column names is snake case, writing words in lowercase and separating them with an underscore (`_`). For example: `delivery_orders`

These are few essential SQL commands you should know to get started.

With SQL, you can easily query, manipulate, and analyze data to make informed decisions and solve real-world problems.

# --questions--

## --text--

What does the acronym SQL stand for?

## --answers--

Structured Query Language

---

Simple Query Language

### --feedback--

Think about the purpose of SQL and the words in the acronym that describe its functionality.

---

Sequential Query Language

### --feedback--

Think about the purpose of SQL and the words in the acronym that describe its functionality.

---

Standard Query Language

### --feedback--

Think about the purpose of SQL and the words in the acronym that describe its functionality.

## --video-solution--

1

## --text--

What is SQL primarily used for?

## --answers--

Creating web pages.

### --feedback--

Think about how SQL interacts with data.

---

Developing mobile applications.

### --feedback--

Think about how SQL interacts with data.

---

Managing relational databases.

---

Writing server-side scripts.

### --feedback--

Think about how SQL interacts with data.

## --video-solution--

3

## --text--

What is a relational database?

## --answers--

A collection of unstructured data.

### --feedback--

Think about how data is organized in a relational database.

---

A database that stores data in tables.

---

A programming language.

### --feedback--

Think about how data is organized in a relational database.

---

A type of network.

### --feedback--

Think about how data is organized in a relational database.

## --video-solution--

2
